import org.jetbrains.kotlin.gradle.dsl.JvmTarget

plugins {
	alias(libs.plugins.kotlin.multiplatform)
	alias(libs.plugins.kotlin.serialization)
	alias(libs.plugins.compose.compiler)
	alias(libs.plugins.jetbrains.compose)
	alias(libs.plugins.android.kotlin.multiplatform.library)
	alias(libs.plugins.jetbrains.kover)
	alias(libs.plugins.compose.report.generator)
}

group = "com.darkrockstudios.apps.hammer.composeui"
version = libs.versions.app.get()

kotlin {
	androidLibrary {
		namespace = "com.darkrockstudios.apps.hammer.composeui"
		compileSdk = libs.versions.android.sdk.compile.get().toInt()
		minSdk = libs.versions.android.sdk.min.get().toInt()

		androidResources {
			enable = true
		}

		compilerOptions {
			jvmTarget.set(JvmTarget.fromTarget(libs.versions.jvm.get()))
		}
	}
	jvm("desktop") {
		compilerOptions {
			jvmTarget.set(JvmTarget.fromTarget(libs.versions.jvm.get()))
		}
	}

	applyDefaultHierarchyTemplate()

	sourceSets {
		all {
			languageSettings {
				optIn("kotlin.io.encoding.ExperimentalEncodingApi")
				optIn("kotlin.uuid.ExperimentalUuidApi")
				optIn("com.arkivanov.decompose.ExperimentalDecomposeApi")
				optIn("androidx.compose.animation.ExperimentalSharedTransitionApi")
			}
		}

		val commonMain by getting {
			@OptIn(org.jetbrains.compose.ExperimentalComposeLibrary::class)
			dependencies {
				api(project(":common"))
				api(compose.runtime)
				api(compose.components.resources)
				api(compose.uiTooling)
				api(compose.preview)
				api(compose.foundation)
				api(compose.material)
				api(compose.material3)
				api(compose.animation)
				api(compose.animationGraphics)
				api(compose.materialIconsExtended)
				api(libs.multiplatform.window.size)
				api(libs.jetbrains.compose.ui.util)
				api(libs.jetbrains.compose.ui.text)
				api(libs.decompose.compose)
				api(libs.decompose.compose.experimental)
				api(libs.filekit.dialogs.compose)
				api(libs.coil.compose)
				api(libs.coil.svg)
				api(libs.kmpalette.core)
				api(libs.kmpalette.extensions.file)
				implementation(libs.koalaplot.core)
				implementation(libs.aboutlibraries.core)
				implementation(libs.aboutlibraries.compose)
				implementation(libs.compose.texteditor)
				implementation(libs.compose.texteditor.find)
				implementation(libs.compose.texteditor.spellcheck)
				implementation(libs.platform.spellcheckerkt)
				implementation(libs.fluidsonic.locale)
			}
		}
		val commonTest by getting {
			@OptIn(org.jetbrains.compose.ExperimentalComposeLibrary::class)
			dependencies {
				implementation(kotlin("test"))
				implementation(libs.okio.fakefilesystem)
				implementation(libs.kotlin.reflect)
				implementation(compose.desktop.uiTestJUnit4)
			}
		}
		val androidMain by getting {
			dependencies {
				api(libs.koin.compose)
				implementation(libs.androidx.window)
				implementation(libs.activity.compose)
				implementation(libs.moko.permissions.compose)
			}
		}
		val desktopMain by getting {
			dependencies {
				implementation(compose.desktop.currentOs)

				//implementation(libs.jSystemThemeDetector)
				// TODO using the `libs` syntax doesn't work with exclude, remove this once
				// https://github.com/Dansoftowner/jSystemThemeDetector/pull/39
				// is merged
				api("com.github.Dansoftowner:jSystemThemeDetector:3.9.1") {
					exclude(group = "net.java.dev.jna")
				}

				implementation(libs.jna)
				implementation(libs.jna.platform)
			}
		}

		val desktopTest by getting {
			dependencies {
				implementation(libs.junit.jupiter)
				runtimeOnly(libs.junit.vintage.engine)
				implementation(libs.mockk)
			}
		}
	}
}

kover {
	reports {
		filters {
			includes {
				packages("com.darkrockstudios.apps.hammer.*")
			}
		}
	}
}