package com.darkrockstudios.apps.hammer.common.components.storyeditor.sceneeditor.scenemetadata

import com.arkivanov.decompose.value.Value
import com.darkrockstudios.apps.hammer.common.data.SceneItem
import com.darkrockstudios.apps.hammer.common.data.sceneeditorrepository.scenemetadata.SceneMetadata
import com.darkrockstudios.apps.hammer.common.dependencyinjection.HammerComponent

interface SceneMetadataPanel : HammerComponent {
	val state: Value<State>

	fun updateOutline(text: String)
	fun updateNotes(text: String)
	fun updateDraftName(text: String)
	fun validateDraftName(text: String): Boolean

	data class State(
		val sceneItem: SceneItem,
		val filename: String = "",
		val path: String = "",
		val wordCount: Int = 0,
		val metadata: SceneMetadata = SceneMetadata(),
	)
}