# SnapSafe
*The camera that minds its own business.*

_Available on:_

[![Google Play](https://img.shields.io/endpoint?color=green&logo=google-play&logoColor=green&url=https%3A%2F%2Fplay.cuzi.workers.dev%2Fplay%3Fi%3Dcom.darkrockstudios.app.securecamera%26l%3DGoogle%2520Play%26m%3D%24version)](https://play.google.com/store/apps/details?id=com.darkrockstudios.app.securecamera)
[![F-Droid](https://img.shields.io/f-droid/v/com.darkrockstudios.app.securecamera?logo=FDROID)](https://f-droid.org/en/packages/com.darkrockstudios.app.securecamera/)
[![GitHub](https://img.shields.io/github/v/release/SecureCamera/SecureCameraAndroid?include_prereleases&logo=github)](https://github.com/SecureCamera/SecureCameraAndroid/releases/latest)

[snapsafe.org](https://snapsafe.org/)

[![featureGraphic.png](fastlane/metadata/android/en-US/images/featureGraphic.png)](http://www.snapsafe.org)

[![Build](https://github.com/SecureCamera/SecureCameraAndroid/actions/workflows/build.yml/badge.svg)](https://github.com/SecureCamera/SecureCameraAndroid/actions/workflows/build.yml)
[![Codacy Badge](https://app.codacy.com/project/badge/Grade/8fc95b1f8c134ddfae9547226c753402)](https://app.codacy.com/gh/SecureCamera/SecureCameraAndroid/dashboard?utm_source=gh&utm_medium=referral&utm_content=&utm_campaign=Badge_grade)
[![Crowdin](https://badges.crowdin.net/snap-safe-android/localized.svg)](https://crowdin.com/project/snap-safe-android)

----

## Why SnapSafe?

**SnapSafe** is a camera app that has been engineered from the ground up to protect your photos.

Attacks come in many forms, from accidental swipes, to intrusive surveillance, and even malicious code.
**SnapSafe** can protect your photos from all angles.

### Key Features

* 🔒 **Zero‑Leak Design** – The app has no internet access; android backups are prevented.
* 🛡️ **Fully Encrypted** – Shots are written to encrypted, app‑private storage.
* 🔢 **PIN‑Locked Gallery** – A separate PIN stands between curious thumbs and your photos.
* 📤 **Secure Sharing** – Metadata is scrubbed and filenames are randomized when you share.
* 😶‍🌫️ **Auto-Face Blur** – Obfuscate faces automatically with our secure blur algorithm.
* 🗺️ **Granular Location** – Add coarse, fine, or zero location data—your call.
* ☠️ **Poison Pill** – Set a special PIN, that when entered, appears to work normally but actually deletes your existing
  photos.
* 🎭 **Decoy Photos** – Select innocuous decoy photos, these will be preserved when your Poison Pill is activated.
* 👀 **100 % Open Source** – Auditable code in plain sight.

### On the Roadmap

* Encrypted video recording. _Maybe._
* Improved photo-taking experience

## Read our papers on SnapSafe

- [Security Design](docs/SnapSafe%20Security%20on%20Android.md)
- [Attack Vectors](docs/SnapSafe%20Attack%20Vectors.md)
- [Related Incidents](docs/SnapSafe%20Related%20Incidents.md)

---

## 🪨 Dark Rock Studios

[**Dark Rock Studios**](https://darkrock.studio/) is all about building **Free and Open Source Software**.

🐛 Found bugs?  
💡 Have suggestions?  
📚 Want to help translate?  
🎮 Interested in our other apps?  
👉 Join our community of Open Source enthusiasts on [**Discord**](https://discord.gg/ju2RQa5x8W)!

---

## License

SnapSafe is released under the [MIT License](LICENSE). Use it, fork it, improve it—just keep it open.

---

## Privacy

Our full, ultra‑brief Privacy Policy lives in [PRIVACY.md](PRIVACY.md). Spoiler: we collect nothing.

---

## Development

See [docs/HOW-TO-RELEASE](docs/HOW-TO-RELEASE.md) on how to publish a new release.

### Contributing

Pull requests are happily accepted.

Start with an issue or draft PR and we can talk it through.
