/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl.repository;

import com.google.code.microlog4android.Level;
import com.google.code.microlog4android.Logger;
import com.google.code.microlog4android.repository.AbstractRepositoryNode;
import java.util.Hashtable;
import org.slf4j.impl.MicrologLoggerAdapter;

public class Slf4jRepositoryNode
extends AbstractRepositoryNode {
    private Slf4jRepositoryNode parent;
    private Hashtable<String, Slf4jRepositoryNode> children = new Hashtable(17);
    private MicrologLoggerAdapter logger;

    public Slf4jRepositoryNode(String name, MicrologLoggerAdapter logger) {
        this.name = name;
        this.logger = logger;
    }

    public Slf4jRepositoryNode(String name, Slf4jRepositoryNode parent) {
        this.name = name;
        this.parent = parent;
        this.logger = new MicrologLoggerAdapter(new Logger(name));
    }

    public Slf4jRepositoryNode(String name, MicrologLoggerAdapter logger, Slf4jRepositoryNode parent) {
        this.name = name;
        this.logger = logger;
        this.parent = parent;
    }

    public void addChild(Slf4jRepositoryNode child) {
        this.children.put(child.getName(), child);
    }

    public MicrologLoggerAdapter getLogger() {
        return this.logger;
    }

    public Slf4jRepositoryNode getChildNode(String name) {
        return this.children.get(name);
    }

    public void resetLogger() {
        this.children.clear();
        this.logger.getMicrologLogger().resetLogger();
        this.logger.getMicrologLogger().setLevel(Level.DEBUG);
    }

    public Slf4jRepositoryNode getParent() {
        return this.parent;
    }

    public void setParent(Slf4jRepositoryNode parent) {
        this.parent = parent;
    }
}

