/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl.repository;

import com.google.code.microlog4android.Level;
import com.google.code.microlog4android.repository.CommonLoggerRepository;
import com.google.code.microlog4android.repository.LoggerNamesUtil;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.impl.MicrologLoggerAdapter;
import org.slf4j.impl.repository.Slf4jRepositoryNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Slf4jLoggerRepository implements ILoggerFactory,
CommonLoggerRepository
{
    INSTANCE;

    private Slf4jRepositoryNode rootNode;
    private Hashtable<String, Slf4jRepositoryNode> leafNodeHashtable = new Hashtable(43);

    private Slf4jLoggerRepository() {
        MicrologLoggerAdapter rootLogger = new MicrologLoggerAdapter("");
        rootLogger.getMicrologLogger().setLevel(Level.DEBUG);
        this.rootNode = new Slf4jRepositoryNode("", rootLogger);
    }

    public Logger getRootLogger() {
        return this.rootNode.getLogger();
    }

    @Override
    public synchronized Logger getLogger(String name) {
        Slf4jRepositoryNode node = this.leafNodeHashtable.get(name);
        MicrologLoggerAdapter logger = null;
        if (node == null) {
            logger = new MicrologLoggerAdapter(name);
            this.addLogger(logger);
        } else {
            logger = node.getLogger();
        }
        return logger;
    }

    void addLogger(MicrologLoggerAdapter logger) {
        String[] pathComponents;
        String loggerName = logger.getName();
        Slf4jRepositoryNode currentNode = this.rootNode;
        for (String pathComponent : pathComponents = LoggerNamesUtil.getLoggerNameComponents(loggerName)) {
            Slf4jRepositoryNode child = currentNode.getChildNode(pathComponent);
            if (child != null) continue;
            currentNode = this.createNewChildNode(pathComponent, currentNode);
        }
        if (pathComponents.length > 0) {
            String leafName = LoggerNamesUtil.getClassName(pathComponents);
            Slf4jRepositoryNode leafNode = new Slf4jRepositoryNode(leafName, logger, currentNode);
            currentNode.addChild(leafNode);
            this.leafNodeHashtable.put(loggerName, leafNode);
        }
    }

    public void setLevel(String name, Level level) {
        Slf4jRepositoryNode leafNode = this.leafNodeHashtable.get(name);
        if (leafNode != null) {
            leafNode.getLogger().getMicrologLogger().setLevel(level);
        } else {
            String[] pathComponents;
            Slf4jRepositoryNode currentNode = this.rootNode;
            for (String pathComponent : pathComponents = LoggerNamesUtil.getLoggerNameComponents(name)) {
                Slf4jRepositoryNode child = currentNode.getChildNode(pathComponent);
                if (child != null) continue;
                currentNode = this.createNewChildNode(pathComponent, currentNode);
            }
            if (currentNode != null) {
                currentNode.getLogger().getMicrologLogger().setLevel(level);
            }
        }
    }

    private Slf4jRepositoryNode createNewChildNode(String pathComponent, Slf4jRepositoryNode currentNode) {
        Slf4jRepositoryNode newChild = new Slf4jRepositoryNode(pathComponent, currentNode);
        currentNode.addChild(newChild);
        return newChild;
    }

    @Override
    public Level getEffectiveLevel(String loggerName) {
        Level effectiveLevel = null;
        for (Slf4jRepositoryNode currentNode = this.leafNodeHashtable.get(loggerName); effectiveLevel == null && currentNode != null; currentNode = currentNode.getParent()) {
            MicrologLoggerAdapter micrologLoggerAdapter = currentNode.getLogger();
            com.google.code.microlog4android.Logger logger = micrologLoggerAdapter.getMicrologLogger();
            effectiveLevel = logger.getLevel();
        }
        return effectiveLevel;
    }

    public boolean contains(String name) {
        return this.leafNodeHashtable.containsKey(name);
    }

    public int numberOfLeafNodes() {
        return this.leafNodeHashtable.size();
    }

    public void reset() {
        this.rootNode.resetLogger();
        this.leafNodeHashtable.clear();
    }

    public void shutdown() {
        Enumeration<Slf4jRepositoryNode> leafNodes = this.leafNodeHashtable.elements();
        while (leafNodes.hasMoreElements()) {
            Slf4jRepositoryNode node = leafNodes.nextElement();
            MicrologLoggerAdapter logger = node.getLogger();
            if (logger == null) continue;
            try {
                logger.getMicrologLogger().close();
            }
            catch (IOException e) {}
        }
    }
}

