/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import com.google.code.microlog4android.Level;
import com.google.code.microlog4android.Logger;
import org.slf4j.helpers.MarkerIgnoringBase;
import org.slf4j.impl.repository.Slf4jLoggerRepository;

public class MicrologLoggerAdapter
extends MarkerIgnoringBase {
    private static final long serialVersionUID = 3934653965724860568L;
    private final transient Logger logger;

    public MicrologLoggerAdapter(Logger logger) {
        this.logger = logger;
        this.name = logger.getName();
        logger.setCommonRepository(Slf4jLoggerRepository.INSTANCE);
    }

    public MicrologLoggerAdapter(String name) {
        this.logger = new Logger(name, Slf4jLoggerRepository.INSTANCE);
        this.name = name;
    }

    public Logger getMicrologLogger() {
        return this.logger;
    }

    public String getName() {
        return this.logger.getName();
    }

    public boolean isTraceEnabled() {
        return this.isLoggerEnabled(Level.TRACE);
    }

    public void trace(String msg) {
        this.logger.trace(msg);
    }

    public void trace(String format, Object param1) {
        throw new UnsupportedOperationException("trace(String, Object) is not implemented yet");
    }

    public void trace(String format, Object param1, Object param2) {
        throw new UnsupportedOperationException("trace(String, Object, Object) is not implemented yet");
    }

    public void trace(String format, Object[] argArray) {
        throw new UnsupportedOperationException("trace(String, Object[]) is not implemented yet");
    }

    public void trace(String msg, Throwable t) {
        this.logger.trace(msg, t);
    }

    public boolean isDebugEnabled() {
        return this.isLoggerEnabled(Level.DEBUG);
    }

    public void debug(String msg) {
        this.logger.debug(msg);
    }

    public void debug(String format, Object arg1) {
        throw new UnsupportedOperationException("debug(String, Object) is not implemented yet");
    }

    public void debug(String format, Object param1, Object param2) {
        throw new UnsupportedOperationException("debug(String, Object, Object) is not implemented yet");
    }

    public void debug(String format, Object[] argArray) {
        throw new UnsupportedOperationException("debug(String, Object[]) is not implemented yet");
    }

    public void debug(String msg, Throwable t) {
        this.logger.debug(msg, t);
    }

    public boolean isInfoEnabled() {
        return this.isLoggerEnabled(Level.INFO);
    }

    public void info(String msg) {
        this.logger.info(msg);
    }

    public void info(String format, Object arg) {
        throw new UnsupportedOperationException("info(String, Object) is not implemented yet");
    }

    public void info(String format, Object arg1, Object arg2) {
        throw new UnsupportedOperationException("info(String, Object, Object) is not implemented yet");
    }

    public void info(String format, Object[] argArray) {
        throw new UnsupportedOperationException("info(String, Object[]) is not implemented yet");
    }

    public void info(String msg, Throwable t) {
        this.logger.info(msg, t);
    }

    public boolean isWarnEnabled() {
        return true;
    }

    public void warn(String msg) {
        this.logger.warn(msg);
    }

    public void warn(String format, Object arg) {
        throw new UnsupportedOperationException("warn(String, Object) is not implemented yet");
    }

    public void warn(String format, Object arg1, Object arg2) {
        throw new UnsupportedOperationException("warn(String, Object, Object) is not implemented yet");
    }

    public void warn(String format, Object[] argArray) {
    }

    public void warn(String msg, Throwable t) {
        this.logger.warn(msg, t);
    }

    public boolean isErrorEnabled() {
        return true;
    }

    public void error(String msg) {
        this.logger.error(msg);
    }

    public void error(String format, Object arg) {
        throw new UnsupportedOperationException("error(String, Object) is not implemented yet");
    }

    public void error(String format, Object arg1, Object arg2) {
        throw new UnsupportedOperationException("error(String, Object, Object) is not implemented yet");
    }

    public void error(String format, Object[] argArray) {
        throw new UnsupportedOperationException("error(String, Object[]) is not implemented yet");
    }

    public void error(String msg, Throwable t) {
        this.logger.error(msg, t);
    }

    private boolean isLoggerEnabled(Level level) {
        return this.logger.getEffectiveLevel().toInt() <= level.toInt();
    }
}

