/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.microlog4android.repository;

import com.google.code.microlog4android.Level;
import com.google.code.microlog4android.Logger;
import com.google.code.microlog4android.repository.AbstractRepositoryNode;
import com.google.code.microlog4android.repository.DefaultLoggerRepository;
import java.util.Hashtable;

public class MicrologRepositoryNode
extends AbstractRepositoryNode {
    private MicrologRepositoryNode parent = null;
    private Hashtable<String, MicrologRepositoryNode> children = new Hashtable(17);
    private Logger logger;

    public MicrologRepositoryNode(String name, Logger logger) {
        this.name = name;
        this.logger = logger;
    }

    public MicrologRepositoryNode(String name, MicrologRepositoryNode parent) {
        this.name = name;
        this.parent = parent;
        this.logger = new Logger(name);
        this.logger.setCommonRepository(DefaultLoggerRepository.INSTANCE);
    }

    public MicrologRepositoryNode(String name, Logger logger, MicrologRepositoryNode parent) {
        this.name = name;
        this.logger = logger;
        this.parent = parent;
    }

    public void addChild(MicrologRepositoryNode child) {
        this.children.put(child.getName(), child);
    }

    public Logger getLogger() {
        return this.logger;
    }

    public MicrologRepositoryNode getChildNode(String name) {
        return this.children.get(name);
    }

    public void resetLogger() {
        this.children.clear();
        this.logger.resetLogger();
        this.logger.setLevel(Level.DEBUG);
    }

    public MicrologRepositoryNode getParent() {
        return this.parent;
    }

    public void setParent(MicrologRepositoryNode parent) {
        this.parent = parent;
    }
}

