/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.microlog4android;

import com.google.code.microlog4android.Logger;
import com.google.code.microlog4android.factory.DefaultRepositoryFactory;
import com.google.code.microlog4android.repository.LoggerRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggerFactory {
    private static final LoggerRepository loggerRepository = DefaultRepositoryFactory.getDefaultLoggerRepository();

    public static Logger getLogger() {
        return loggerRepository.getRootLogger();
    }

    public static Logger getLogger(String name) {
        if (name == null) {
            throw new IllegalArgumentException("The Logger name must not be null.");
        }
        return loggerRepository.getLogger(name);
    }

    public static Logger getLogger(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("The clazz must not be null.");
        }
        return LoggerFactory.getLogger(clazz.getName());
    }

    public static void shutdown() {
        loggerRepository.shutdown();
    }

    public static LoggerRepository getLoggerRepository() {
        return loggerRepository;
    }
}

