/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.microlog4android;

import android.util.Log;
import com.google.code.microlog4android.Level;
import com.google.code.microlog4android.StopWatch;
import com.google.code.microlog4android.appender.Appender;
import com.google.code.microlog4android.factory.DefaultAppenderFactory;
import com.google.code.microlog4android.repository.CommonLoggerRepository;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class Logger {
    private static final String TAG = "Microlog.Logger";
    public static final Level DEFAULT_LOG_LEVEL = Level.DEBUG;
    public static final String DEFAULT_CLIENT_ID = "Microlog";
    private CommonLoggerRepository commonLoggerRepository = null;
    private String clientID = "Microlog";
    private String name;
    private Level level;
    private static final StopWatch stopWatch = new StopWatch();
    private static final List<Appender> appenderList = new ArrayList<Appender>(4);
    private static boolean firstLogEvent = true;

    public Logger(String name) {
        this.name = name;
    }

    public Logger(String name, CommonLoggerRepository commonLoggerRepository) {
        this.name = name;
        this.commonLoggerRepository = commonLoggerRepository;
    }

    public synchronized void setCommonRepository(CommonLoggerRepository commonLoggerRepository) {
        this.commonLoggerRepository = commonLoggerRepository;
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) throws IllegalArgumentException {
        if (level == null) {
            throw new IllegalArgumentException("The level must not be null.");
        }
        this.level = level;
    }

    public Level getEffectiveLevel() {
        Level effectiveLevel = this.level;
        if (effectiveLevel == null && !this.name.equals("")) {
            if (this.commonLoggerRepository == null) {
                throw new IllegalStateException("CommonLoggerRepository has not been set");
            }
            effectiveLevel = this.commonLoggerRepository.getEffectiveLevel(this.name);
        }
        return effectiveLevel;
    }

    public String getClientID() {
        return this.clientID;
    }

    public void setClientID(String clientID) {
        this.clientID = clientID;
    }

    public String getName() {
        return this.name;
    }

    public void addAppender(Appender appender) throws IllegalArgumentException {
        if (appender == null) {
            throw new IllegalArgumentException("Appender not allowed to be null");
        }
        if (!appenderList.contains(appender)) {
            appenderList.add(appender);
        }
    }

    public void removeAppender(Appender appender) throws IllegalArgumentException {
        if (appender == null) {
            throw new IllegalArgumentException("The appender must not be null.");
        }
        if (appender.isLogOpen()) {
            try {
                appender.close();
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)("Failed to close appender. " + e));
            }
        }
        appenderList.remove(appender);
    }

    public void removeAllAppenders() {
        for (Appender appender : appenderList) {
            if (!appender.isLogOpen()) continue;
            try {
                appender.close();
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)("Failed to close appender. " + e));
            }
        }
        appenderList.clear();
    }

    public int getNumberOfAppenders() {
        return appenderList.size();
    }

    public Appender getAppender(int index) {
        return appenderList.get(index);
    }

    public void log(Level level, Object message) throws IllegalArgumentException {
        this.log(level, message, null);
    }

    public void log(Level level, Object message, Throwable t) throws IllegalArgumentException {
        if (level == null) {
            throw new IllegalArgumentException("The level must not be null.");
        }
        if (this.getEffectiveLevel().toInt() <= level.toInt() && level.toInt() > -1) {
            if (firstLogEvent) {
                this.addDefaultAppender();
                try {
                    this.open();
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)("Failed to open the log. " + e));
                }
                stopWatch.start();
                firstLogEvent = false;
            }
            for (Appender appender : appenderList) {
                appender.doLog(this.clientID, this.name, stopWatch.getCurrentTime(), level, message, t);
            }
        }
    }

    private void addDefaultAppender() {
        if (appenderList.size() == 0) {
            Log.w((String)TAG, (String)"Warning! No appender is set, using LogCatAppender with PatternFormatter");
            Appender appender = DefaultAppenderFactory.createDefaultAppender();
            this.addAppender(appender);
        }
    }

    public boolean isTraceEnabled() {
        Level effectiveLevel = this.getEffectiveLevel();
        return effectiveLevel.toInt() <= 0;
    }

    public void trace(Object message) {
        this.log(Level.TRACE, message, null);
    }

    public void trace(Object message, Throwable t) {
        this.log(Level.TRACE, message, t);
    }

    public boolean isDebugEnabled() {
        Level effectiveLevel = this.getEffectiveLevel();
        return effectiveLevel.toInt() <= 1;
    }

    public void debug(Object message) {
        this.log(Level.DEBUG, message, null);
    }

    public void debug(Object message, Throwable t) {
        this.log(Level.DEBUG, message, t);
    }

    public boolean isInfoEnabled() {
        Level effectiveLevel = this.getEffectiveLevel();
        return effectiveLevel.toInt() <= 2;
    }

    public void info(Object message) {
        this.log(Level.INFO, message, null);
    }

    public void info(Object message, Throwable t) {
        this.log(Level.INFO, message, t);
    }

    public void warn(Object message) {
        this.log(Level.WARN, message, null);
    }

    public void warn(Object message, Throwable t) {
        this.log(Level.WARN, message, t);
    }

    public void error(Object message) {
        this.log(Level.ERROR, message, null);
    }

    public void error(Object message, Throwable t) {
        this.log(Level.ERROR, message, t);
    }

    public void fatal(Object message) {
        this.log(Level.FATAL, message, null);
    }

    public void fatal(Object message, Throwable t) {
        this.log(Level.FATAL, message, t);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append('[');
        for (Appender appender : appenderList) {
            stringBuffer.append(appender);
            stringBuffer.append(';');
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public synchronized void resetLogger() {
        appenderList.clear();
        stopWatch.stop();
        stopWatch.reset();
        firstLogEvent = true;
    }

    void open() throws IOException {
        for (Appender appender : appenderList) {
            appender.open();
        }
    }

    public void close() throws IOException {
        for (Appender appender : appenderList) {
            appender.close();
        }
        stopWatch.stop();
        firstLogEvent = true;
    }
}

