/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.morphia.query;

import com.google.code.morphia.mapping.MappedField;
import com.google.code.morphia.mapping.Mapper;
import com.google.code.morphia.query.FilterOperator;
import com.google.code.morphia.query.QueryException;
import com.google.code.morphia.query.UpdateOperations;
import com.google.code.morphia.query.UpdateOperator;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateOpsImpl<T>
implements UpdateOperations<T> {
    Map<String, Map<String, Object>> ops = new HashMap<String, Map<String, Object>>();
    Mapper mapr;
    Class<T> clazz;
    boolean validateNames = true;
    boolean validateTypes = true;
    boolean isolated = false;

    public UpdateOpsImpl(Class<T> type, Mapper mapper) {
        this.mapr = mapper;
        this.clazz = type;
    }

    @Override
    public UpdateOperations<T> enableValidation() {
        this.validateTypes = true;
        this.validateNames = true;
        return this;
    }

    @Override
    public UpdateOperations<T> disableValidation() {
        this.validateTypes = false;
        this.validateNames = false;
        return this;
    }

    @Override
    public UpdateOperations<T> isolated() {
        this.isolated = true;
        return this;
    }

    public boolean isIsolated() {
        return this.isolated;
    }

    public void setOps(DBObject ops) {
        this.ops = (Map)ops;
    }

    public DBObject getOps() {
        return new BasicDBObject(this.ops);
    }

    @Override
    public UpdateOperations<T> add(String fieldExpr, Object value) {
        return this.add(fieldExpr, value, false);
    }

    @Override
    public UpdateOperations<T> add(String fieldExpr, Object value, boolean addDups) {
        if (value == null) {
            throw new QueryException("Value cannot be null.");
        }
        this.add(addDups ? UpdateOperator.PUSH : UpdateOperator.ADD_TO_SET, fieldExpr, value, true);
        return this;
    }

    @Override
    public UpdateOperations<T> addAll(String fieldExpr, List<?> values, boolean addDups) {
        if (values == null || values.isEmpty()) {
            throw new QueryException("Values cannot be null or empty.");
        }
        if (addDups) {
            this.add(UpdateOperator.PUSH_ALL, fieldExpr, values, true);
        } else {
            this.add(UpdateOperator.ADD_TO_SET_EACH, fieldExpr, values, true);
        }
        return this;
    }

    @Override
    public UpdateOperations<T> dec(String fieldExpr) {
        return this.inc(fieldExpr, -1);
    }

    @Override
    public UpdateOperations<T> inc(String fieldExpr) {
        return this.inc(fieldExpr, 1);
    }

    @Override
    public UpdateOperations<T> inc(String fieldExpr, Number value) {
        if (value == null) {
            throw new QueryException("Value cannot be null.");
        }
        this.add(UpdateOperator.INC, fieldExpr, value, false);
        return this;
    }

    protected UpdateOperations<T> remove(String fieldExpr, boolean firstNotLast) {
        this.add(UpdateOperator.POP, fieldExpr, firstNotLast ? -1 : 1, false);
        return this;
    }

    @Override
    public UpdateOperations<T> removeAll(String fieldExpr, Object value) {
        if (value == null) {
            throw new QueryException("Value cannot be null.");
        }
        this.add(UpdateOperator.PULL, fieldExpr, value, true);
        return this;
    }

    @Override
    public UpdateOperations<T> removeAll(String fieldExpr, List<?> values) {
        if (values == null || values.isEmpty()) {
            throw new QueryException("Value cannot be null or empty.");
        }
        this.add(UpdateOperator.PULL_ALL, fieldExpr, values, true);
        return this;
    }

    @Override
    public UpdateOperations<T> removeFirst(String fieldExpr) {
        return this.remove(fieldExpr, true);
    }

    @Override
    public UpdateOperations<T> removeLast(String fieldExpr) {
        return this.remove(fieldExpr, false);
    }

    @Override
    public UpdateOperations<T> set(String fieldExpr, Object value) {
        if (value == null) {
            throw new QueryException("Value cannot be null.");
        }
        this.add(UpdateOperator.SET, fieldExpr, value, true);
        return this;
    }

    @Override
    public UpdateOperations<T> unset(String fieldExpr) {
        this.add(UpdateOperator.UNSET, fieldExpr, 1, false);
        return this;
    }

    protected List<Object> toDBObjList(MappedField mf, List<?> values) {
        ArrayList<Object> vals = new ArrayList<Object>((int)((double)values.size() * 1.3));
        for (Object obj : values) {
            vals.add(this.mapr.toMongoObject(mf, null, obj));
        }
        return vals;
    }

    protected void add(UpdateOperator op, String f, Object value, boolean convert) {
        String opString;
        if (value == null) {
            throw new QueryException("Val cannot be null");
        }
        Object val = null;
        MappedField mf = null;
        if (this.validateNames || this.validateTypes) {
            StringBuffer sb = new StringBuffer(f);
            mf = Mapper.validate(this.clazz, this.mapr, sb, FilterOperator.EQUAL, val, this.validateNames, this.validateTypes);
            f = sb.toString();
        }
        if (convert) {
            val = UpdateOperator.PULL_ALL.equals((Object)op) && value instanceof List ? this.toDBObjList(mf, value) : this.mapr.toMongoObject(mf, null, value);
        }
        if (UpdateOperator.ADD_TO_SET_EACH.equals((Object)op)) {
            val = new BasicDBObject(UpdateOperator.EACH.val(), val);
        }
        if (val == null) {
            val = value;
        }
        if (!this.ops.containsKey(opString = op.val())) {
            this.ops.put(opString, new HashMap());
        }
        this.ops.get(opString).put(f, val);
    }
}

