/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.morphia.mapping.validation;

import com.google.code.morphia.annotations.Embedded;
import com.google.code.morphia.annotations.Property;
import com.google.code.morphia.annotations.Reference;
import com.google.code.morphia.annotations.Serialized;
import com.google.code.morphia.logging.Logr;
import com.google.code.morphia.logging.MorphiaLoggerFactory;
import com.google.code.morphia.mapping.MappedClass;
import com.google.code.morphia.mapping.validation.ClassConstraint;
import com.google.code.morphia.mapping.validation.ConstraintViolation;
import com.google.code.morphia.mapping.validation.ConstraintViolationException;
import com.google.code.morphia.mapping.validation.classrules.DuplicatedAttributeNames;
import com.google.code.morphia.mapping.validation.classrules.EmbeddedAndId;
import com.google.code.morphia.mapping.validation.classrules.EmbeddedAndValue;
import com.google.code.morphia.mapping.validation.classrules.EntityAndEmbed;
import com.google.code.morphia.mapping.validation.classrules.EntityCannotBeMapOrIterable;
import com.google.code.morphia.mapping.validation.classrules.MultipleId;
import com.google.code.morphia.mapping.validation.classrules.MultipleVersions;
import com.google.code.morphia.mapping.validation.classrules.NoId;
import com.google.code.morphia.mapping.validation.fieldrules.ContradictingFieldAnnotation;
import com.google.code.morphia.mapping.validation.fieldrules.LazyReferenceMissingDependencies;
import com.google.code.morphia.mapping.validation.fieldrules.LazyReferenceOnArray;
import com.google.code.morphia.mapping.validation.fieldrules.MapKeyDifferentFromString;
import com.google.code.morphia.mapping.validation.fieldrules.MapNotSerializable;
import com.google.code.morphia.mapping.validation.fieldrules.MisplacedProperty;
import com.google.code.morphia.mapping.validation.fieldrules.ReferenceToUnidentifiable;
import com.google.code.morphia.mapping.validation.fieldrules.VersionMisuse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappingValidator {
    private static final Logr logger = MorphiaLoggerFactory.get(MappingValidator.class);

    public void validate(List<MappedClass> classes) {
        TreeSet<ConstraintViolation> ve = new TreeSet<ConstraintViolation>(new Comparator<ConstraintViolation>(){

            @Override
            public int compare(ConstraintViolation o1, ConstraintViolation o2) {
                return o1.getLevel().ordinal() > o2.getLevel().ordinal() ? -1 : 1;
            }
        });
        List<ClassConstraint> rules = this.getConstraints();
        for (MappedClass c : classes) {
            for (ClassConstraint v : rules) {
                v.check(c, ve);
            }
        }
        if (!ve.isEmpty()) {
            ConstraintViolation worst = (ConstraintViolation)ve.iterator().next();
            ConstraintViolation.Level maxLevel = worst.getLevel();
            if (maxLevel.ordinal() >= ConstraintViolation.Level.FATAL.ordinal()) {
                throw new ConstraintViolationException(ve);
            }
            ArrayList<LogLine> l = new ArrayList<LogLine>();
            for (ConstraintViolation v : ve) {
                l.add(new LogLine(v));
            }
            Collections.sort(l);
            for (LogLine line : l) {
                line.log(logger);
            }
        }
    }

    private List<ClassConstraint> getConstraints() {
        ArrayList<ClassConstraint> constraints = new ArrayList<ClassConstraint>(32);
        constraints.add(new MultipleId());
        constraints.add(new MultipleVersions());
        constraints.add(new NoId());
        constraints.add(new EmbeddedAndId());
        constraints.add(new EntityAndEmbed());
        constraints.add(new EmbeddedAndValue());
        constraints.add(new EntityCannotBeMapOrIterable());
        constraints.add(new DuplicatedAttributeNames());
        constraints.add(new MisplacedProperty());
        constraints.add(new ReferenceToUnidentifiable());
        constraints.add(new LazyReferenceMissingDependencies());
        constraints.add(new LazyReferenceOnArray());
        constraints.add(new MapKeyDifferentFromString());
        constraints.add(new MapNotSerializable());
        constraints.add(new VersionMisuse());
        constraints.add(new ContradictingFieldAnnotation(Reference.class, Serialized.class));
        constraints.add(new ContradictingFieldAnnotation(Reference.class, Property.class));
        constraints.add(new ContradictingFieldAnnotation(Reference.class, Embedded.class));
        constraints.add(new ContradictingFieldAnnotation(Embedded.class, Serialized.class));
        constraints.add(new ContradictingFieldAnnotation(Embedded.class, Property.class));
        constraints.add(new ContradictingFieldAnnotation(Property.class, Serialized.class));
        return constraints;
    }

    @Deprecated
    public void validate(MappedClass mappedClass) {
        this.validate(Arrays.asList(mappedClass));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class LogLine
    implements Comparable<LogLine> {
        private ConstraintViolation v;

        LogLine(ConstraintViolation v) {
            this.v = v;
        }

        void log(Logr logger) {
            switch (this.v.getLevel()) {
                case SEVERE: {
                    logger.error(this.v.render());
                }
                case WARNING: {
                    logger.warning(this.v.render());
                }
                case INFO: {
                    logger.info(this.v.render());
                    break;
                }
                case MINOR: {
                    logger.debug(this.v.render());
                    break;
                }
                default: {
                    throw new IllegalStateException("Cannot log " + ConstraintViolation.class.getSimpleName() + " of Level " + (Object)((Object)this.v.getLevel()));
                }
            }
        }

        @Override
        public int compareTo(LogLine o) {
            return this.v.getPrefix().compareTo(o.v.getPrefix());
        }
    }
}

