/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.morphia.mapping;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.bson.types.Binary;

public class Serializer {
    public static byte[] serialize(Object o, boolean zip) throws IOException {
        ByteArrayOutputStream baos;
        OutputStream os = baos = new ByteArrayOutputStream();
        if (zip) {
            os = new GZIPOutputStream(os);
        }
        ObjectOutputStream oos = new ObjectOutputStream(os);
        oos.writeObject(o);
        oos.flush();
        oos.close();
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object deserialize(Object data, boolean zipped) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bais = data instanceof Binary ? new ByteArrayInputStream(((Binary)data).getData()) : new ByteArrayInputStream((byte[])data);
        InputStream is = bais;
        try {
            if (zipped) {
                is = new GZIPInputStream(is);
            }
            ObjectInputStream ois = new ObjectInputStream(is);
            Object object = ois.readObject();
            return object;
        }
        finally {
            is.close();
        }
    }
}

