/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.morphia.dao;

import com.google.code.morphia.Datastore;
import com.google.code.morphia.DatastoreImpl;
import com.google.code.morphia.Key;
import com.google.code.morphia.Morphia;
import com.google.code.morphia.dao.DAO;
import com.google.code.morphia.query.Query;
import com.google.code.morphia.query.QueryResults;
import com.google.code.morphia.query.UpdateOperations;
import com.google.code.morphia.query.UpdateResults;
import com.mongodb.DBCollection;
import com.mongodb.Mongo;
import com.mongodb.WriteConcern;
import com.mongodb.WriteResult;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicDAO<T, K>
implements DAO<T, K> {
    protected Class<T> entityClazz;
    protected DatastoreImpl ds;

    public BasicDAO(Class<T> entityClass, Mongo mongo, Morphia morphia, String dbName) {
        this.initDS(mongo, morphia, dbName);
        this.initType(entityClass);
    }

    public BasicDAO(Class<T> entityClass, Datastore ds) {
        this.ds = (DatastoreImpl)ds;
        this.initType(entityClass);
    }

    protected BasicDAO(Mongo mongo, Morphia morphia, String dbName) {
        this.initDS(mongo, morphia, dbName);
        this.initType((Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0]);
    }

    protected BasicDAO(Datastore ds) {
        this.ds = (DatastoreImpl)ds;
        this.initType((Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0]);
    }

    protected void initType(Class<T> type) {
        this.entityClazz = type;
        this.ds.getMapper().addMappedClass(type);
    }

    protected void initDS(Mongo mon, Morphia mor, String db) {
        this.ds = new DatastoreImpl(mor, mon, db);
    }

    protected List<?> keysToIds(List<Key<T>> keys) {
        ArrayList<Object> ids = new ArrayList<Object>(keys.size() * 2);
        for (Key<T> key : keys) {
            ids.add(key.getId());
        }
        return ids;
    }

    @Override
    public DBCollection getCollection() {
        return this.ds.getCollection((Class)this.entityClazz);
    }

    @Override
    public Query<T> createQuery() {
        return this.ds.createQuery(this.entityClazz);
    }

    @Override
    public UpdateOperations<T> createUpdateOperations() {
        return this.ds.createUpdateOperations(this.entityClazz);
    }

    @Override
    public Class<T> getEntityClass() {
        return this.entityClazz;
    }

    @Override
    public Key<T> save(T entity) {
        return this.ds.save(entity);
    }

    @Override
    public Key<T> save(T entity, WriteConcern wc) {
        return this.ds.save(entity, wc);
    }

    @Override
    public UpdateResults<T> updateFirst(Query<T> q, UpdateOperations<T> ops) {
        return this.ds.updateFirst(q, ops);
    }

    @Override
    public UpdateResults<T> update(Query<T> q, UpdateOperations<T> ops) {
        return this.ds.update(q, ops);
    }

    @Override
    public WriteResult delete(T entity) {
        return this.ds.delete(entity);
    }

    @Override
    public WriteResult delete(T entity, WriteConcern wc) {
        return this.ds.delete(entity, wc);
    }

    @Override
    public WriteResult deleteById(K id) {
        return this.ds.delete(this.entityClazz, id);
    }

    @Override
    public WriteResult deleteByQuery(Query q) {
        return this.ds.delete(q);
    }

    @Override
    public T get(K id) {
        return this.ds.get(this.entityClazz, id);
    }

    @Override
    public List<T> findIds(String key, Object value) {
        return this.keysToIds(this.ds.find(this.entityClazz, key, value).asKeyList());
    }

    @Override
    public List<Key<T>> findIds() {
        return this.keysToIds(this.ds.find(this.entityClazz).asKeyList());
    }

    @Override
    public List<Key<T>> findIds(Query<T> q) {
        return this.keysToIds(q.asKeyList());
    }

    @Override
    public boolean exists(String key, Object value) {
        return this.exists(this.ds.find(this.entityClazz, key, value));
    }

    @Override
    public boolean exists(Query<T> q) {
        return this.ds.getCount(q) > 0L;
    }

    @Override
    public long count() {
        return this.ds.getCount(this.entityClazz);
    }

    @Override
    public long count(String key, Object value) {
        return this.count(this.ds.find(this.entityClazz, key, value));
    }

    @Override
    public long count(Query<T> q) {
        return this.ds.getCount(q);
    }

    @Override
    public T findOne(String key, Object value) {
        return this.ds.find(this.entityClazz, key, value).get();
    }

    @Override
    public T findOne(Query<T> q) {
        return q.get();
    }

    @Override
    public QueryResults<T> find() {
        return this.createQuery();
    }

    @Override
    public QueryResults<T> find(Query<T> q) {
        return q;
    }

    @Override
    public Datastore getDatastore() {
        return this.ds;
    }

    @Override
    public void ensureIndexes() {
        this.ds.ensureIndexes(this.entityClazz);
    }
}

