/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.morphia.converters;

import com.google.code.morphia.converters.DefaultConverters;
import com.google.code.morphia.converters.TypeConverter;
import com.google.code.morphia.mapping.MappedField;
import com.google.code.morphia.mapping.MappingException;
import com.google.code.morphia.utils.ReflectionUtils;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapOfValuesConverter
extends TypeConverter {
    private final DefaultConverters converters;

    public MapOfValuesConverter(DefaultConverters converters) {
        this.converters = converters;
    }

    @Override
    protected boolean isSupported(Class<?> c, MappedField optionalExtraInfo) {
        if (optionalExtraInfo != null) {
            return optionalExtraInfo.isMap();
        }
        return ReflectionUtils.implementsInterface(c, Map.class);
    }

    @Override
    public Object decode(Class targetClass, Object fromDBObject, MappedField mf) throws MappingException {
        if (fromDBObject == null) {
            return null;
        }
        Map map = (Map)fromDBObject;
        Map values = this.mapr.getOptions().objectFactory.createMap(mf);
        for (Map.Entry entry : map.entrySet()) {
            Object objKey = this.converters.decode(mf.getMapKeyClass(), entry.getKey());
            values.put(objKey, this.converters.decode(mf.getSubClass(), entry.getValue()));
        }
        return values;
    }

    @Override
    public Object encode(Object value, MappedField mf) {
        if (value == null) {
            return null;
        }
        Map map = (Map)value;
        if (map != null && map.size() > 0) {
            HashMap<String, Object> mapForDb = new HashMap<String, Object>();
            for (Map.Entry entry : map.entrySet()) {
                String strKey = this.converters.encode(entry.getKey()).toString();
                mapForDb.put(strKey, this.converters.encode(entry.getValue()));
            }
            return mapForDb;
        }
        return null;
    }
}

