/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.morphia.converters;

import com.google.code.morphia.ObjectFactory;
import com.google.code.morphia.converters.ConverterException;
import com.google.code.morphia.converters.DefaultConverters;
import com.google.code.morphia.converters.TypeConverter;
import com.google.code.morphia.mapping.MappedField;
import com.google.code.morphia.mapping.MappingException;
import com.google.code.morphia.utils.ReflectionUtils;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IterableConverter
extends TypeConverter {
    private final DefaultConverters chain;

    public IterableConverter(DefaultConverters chain) {
        this.chain = chain;
    }

    protected boolean isSupported(Class c, MappedField mf) {
        if (mf != null) {
            return mf.isMultipleValues() && !mf.isMap();
        }
        return c.isArray() || ReflectionUtils.implementsInterface(c, Iterable.class);
    }

    @Override
    public Object decode(Class targetClass, Object fromDBObject, MappedField mf) throws MappingException {
        if (mf == null || fromDBObject == null) {
            return fromDBObject;
        }
        Class<?> subtypeDest = mf.getSubClass();
        Collection<?> vals = this.createNewCollection(mf);
        if (fromDBObject.getClass().isArray()) {
            for (Object o : (Object[])fromDBObject) {
                vals.add(this.chain.decode(subtypeDest != null ? subtypeDest : o.getClass(), o));
            }
        } else if (fromDBObject instanceof Iterable) {
            for (Object o : (Iterable)fromDBObject) {
                vals.add(this.chain.decode(subtypeDest != null ? subtypeDest : o.getClass(), o));
            }
        } else {
            vals.add(this.chain.decode(subtypeDest != null ? subtypeDest : fromDBObject.getClass(), fromDBObject));
        }
        if (mf.getType().isArray()) {
            return ReflectionUtils.convertToArray(subtypeDest, (ArrayList)vals);
        }
        return vals;
    }

    private Collection<?> createNewCollection(MappedField mf) {
        ObjectFactory of = this.mapr.getOptions().objectFactory;
        return mf.isSet() ? of.createSet(mf) : of.createList(mf);
    }

    @Override
    public Object encode(Object value, MappedField mf) {
        if (value == null) {
            return null;
        }
        List<Object> iterableValues = null;
        if (value.getClass().isArray()) {
            if (Array.getLength(value) == 0) {
                return value;
            }
            if (value.getClass().getComponentType().isPrimitive()) {
                return value;
            }
            iterableValues = Arrays.asList((Object[])value);
        } else {
            if (!(value instanceof Iterable)) {
                throw new ConverterException("Cannot cast " + value.getClass() + " to Iterable for MappedField: " + mf);
            }
            iterableValues = (List<Object>)value;
        }
        ArrayList<Object> values = new ArrayList<Object>();
        if (mf != null && mf.getSubClass() != null) {
            for (Object t : iterableValues) {
                values.add(this.chain.encode(mf.getSubClass(), t));
            }
        } else {
            for (Object t : iterableValues) {
                values.add(this.chain.encode(t));
            }
        }
        if (values.size() > 0) {
            return values;
        }
        return null;
    }
}

