/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.morphia.converters;

import com.google.code.morphia.converters.SimpleValueConverter;
import com.google.code.morphia.converters.TypeConverter;
import com.google.code.morphia.mapping.MappedField;
import com.google.code.morphia.mapping.MappingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumConverter
extends TypeConverter
implements SimpleValueConverter {
    protected boolean isSupported(Class c, MappedField optionalExtraInfo) {
        return c.isEnum();
    }

    @Override
    public Object decode(Class targetClass, Object fromDBObject, MappedField optionalExtraInfo) throws MappingException {
        if (fromDBObject == null) {
            return null;
        }
        return Enum.valueOf(targetClass, fromDBObject.toString());
    }

    @Override
    public Object encode(Object value, MappedField optionalExtraInfo) {
        if (value == null) {
            return null;
        }
        return this.getName((Enum)value);
    }

    private <T extends Enum> String getName(T value) {
        return value.name();
    }
}

