package com.cookiegames.smartcookie.settings.activity

import com.cookiegames.smartcookie.R
import android.content.res.Configuration
import android.os.Bundle
import android.preference.Preference
import android.preference.PreferenceActivity
import android.preference.PreferenceScreen
import android.view.MenuInflater
import android.view.View
import android.view.ViewGroup
import androidx.annotation.LayoutRes
import androidx.appcompat.app.ActionBar
import androidx.appcompat.app.AppCompatDelegate
import androidx.appcompat.widget.Toolbar

/**
 * A [android.preference.PreferenceActivity] which implements and proxies the necessary calls
 * to be used with AppCompat.
 *
 * This technique can be used with an [android.app.Activity] class, not just
 * [android.preference.PreferenceActivity].
 */
abstract class AppCompatPreferenceActivity : PreferenceActivity() {

    private lateinit var delegate: AppCompatDelegate

    override fun onCreate(savedInstanceState: Bundle?) {
        delegate = AppCompatDelegate.create(this, null)
        overridePendingTransition(R.anim.slide_in_from_right, R.anim.fade_out_scale)
        delegate.installViewFactory()
        delegate.onCreate(savedInstanceState)
        super.onCreate(savedInstanceState)
    }

    override fun onPostCreate(savedInstanceState: Bundle?) {
        super.onPostCreate(savedInstanceState)
        delegate.onPostCreate(savedInstanceState)
    }

    fun setSupportActionbar(toolbar: Toolbar?) = delegate.setSupportActionBar(toolbar)

    fun getSupportActionBar(): ActionBar? = delegate.supportActionBar

    override fun getMenuInflater(): MenuInflater = delegate.menuInflater

    override fun setContentView(@LayoutRes layoutResID: Int) = delegate.setContentView(layoutResID)

    override fun setContentView(view: View) = delegate.setContentView(view)

    override fun setContentView(view: View, params: ViewGroup.LayoutParams) =
        delegate.setContentView(view, params)

    override fun addContentView(view: View, params: ViewGroup.LayoutParams) =
        delegate.addContentView(view, params)

    override fun onPostResume() {
        super.onPostResume()
        delegate.onPostResume()
    }

    override fun onTitleChanged(title: CharSequence, color: Int) {
        super.onTitleChanged(title, color)
        delegate.setTitle(title)
    }

    override fun onConfigurationChanged(newConfig: Configuration) {
        super.onConfigurationChanged(newConfig)
        delegate.onConfigurationChanged(newConfig)
    }

    override fun onPause() {
        super.onPause()
        if (isFinishing) {
            overridePendingTransition(R.anim.fade_in_scale, R.anim.slide_out_to_right)
        }
    }

    override fun onStop() {
        super.onStop()
        delegate.onStop()
    }

    override fun onDestroy() {
        super.onDestroy()
        delegate.onDestroy()
    }


    override fun invalidateOptionsMenu() = delegate.invalidateOptionsMenu()
}
