import React from 'react';
import { requireNativeComponent } from 'react-native';
import extractTransform from '../lib/extract/extractTransform';
import extractViewBox from '../lib/extract/extractViewBox';
import units from '../lib/units';
import Shape from './Shape';

export default class Pattern extends Shape {
  static displayName = 'Pattern';

  static defaultProps = {
    x: '0%',
    y: '0%',
    width: '100%',
    height: '100%',
  };

  render() {
    const { props } = this;
    const {
      patternTransform,
      transform,
      id,
      x,
      y,
      width,
      height,
      patternUnits,
      patternContentUnits,
      children,
      viewBox,
      preserveAspectRatio,
    } = props;
    const matrix = extractTransform(patternTransform || transform || props);
    return (
      <RNSVGPattern
        ref={this.refMethod}
        name={id}
        x={x}
        y={y}
        width={width}
        height={height}
        matrix={matrix}
        patternTransform={matrix}
        patternUnits={units[patternUnits] || 0}
        patternContentUnits={
          patternContentUnits ? units[patternContentUnits] : 1
        }
        {...extractViewBox({ viewBox, preserveAspectRatio })}
      >
        {children}
      </RNSVGPattern>
    );
  }
}

const RNSVGPattern = requireNativeComponent('RNSVGPattern');
