function createObj(proto) {
  let F = function() {}
  F.prototype = proto
  return new F()
}

function extend(target /*, mixin1, mixin2...*/) {
  let length = arguments.length, i, prop
  for (i = 1; i < length; i++) {
    for (prop in arguments[i]) {
      target[prop] = arguments[i][prop]
    }
  }
  return target
}

function inherit(Child, Parent /*, mixin1, mixin2...*/) {
  let length = arguments.length, i
  Child.prototype = createObj(Parent.prototype)
  Child.prototype.constructor = Child
  for (i = 2; i < length; i++) {
    extend(Child.prototype, arguments[i])
  }
  return Child
}

export {extend, inherit}
