import _extends from"@babel/runtime/helpers/extends";var _jsxFileName="/Users/satya/Workspace/Callstack/react-navigation-core/src/views/__tests__/NavigationEvents-test.js";import React from'react';import renderer from'react-test-renderer';import NavigationEvents from'../NavigationEvents';import NavigationContext from'../NavigationContext';var createPropListener=function createPropListener(){return jest.fn();};var createEventListenersProp=function createEventListenersProp(){return{onWillFocus:createPropListener(),onDidFocus:createPropListener(),onWillBlur:createPropListener(),onDidBlur:createPropListener()};};var createTestNavigationAndHelpers=function createTestNavigationAndHelpers(){var NavigationListenersAPI=function(){var listeners={willFocus:[],didFocus:[],willBlur:[],didBlur:[]};return{add:function add(eventName,handler){listeners[eventName].push(handler);},remove:function remove(eventName,handler){listeners[eventName]=listeners[eventName].filter(function(h){return h!==handler;});},get:function get(eventName){return listeners[eventName];},call:function call(eventName){listeners[eventName].forEach(function(listener){return listener();});}};}();var navigation={addListener:jest.fn(function(eventName,handler){NavigationListenersAPI.add(eventName,handler);return{remove:function remove(){return NavigationListenersAPI.remove(eventName,handler);}};})};return{navigation:navigation,NavigationListenersAPI:NavigationListenersAPI};};describe('NavigationEvents',function(){it('add all listeners on mount and remove them on unmount, even without any event prop provided (see #5058)',function(){var _createTestNavigation=createTestNavigationAndHelpers(),navigation=_createTestNavigation.navigation,NavigationListenersAPI=_createTestNavigation.NavigationListenersAPI;var component=renderer.create(React.createElement(NavigationEvents,{navigation:navigation,__source:{fileName:_jsxFileName,lineNumber:63}}));expect(NavigationListenersAPI.get('willFocus').length).toBe(1);expect(NavigationListenersAPI.get('didFocus').length).toBe(1);expect(NavigationListenersAPI.get('willBlur').length).toBe(1);expect(NavigationListenersAPI.get('didBlur').length).toBe(1);component.unmount();expect(NavigationListenersAPI.get('willFocus').length).toBe(0);expect(NavigationListenersAPI.get('didFocus').length).toBe(0);expect(NavigationListenersAPI.get('willBlur').length).toBe(0);expect(NavigationListenersAPI.get('didBlur').length).toBe(0);});it('support context-provided navigation',function(){var _createTestNavigation2=createTestNavigationAndHelpers(),navigation=_createTestNavigation2.navigation,NavigationListenersAPI=_createTestNavigation2.NavigationListenersAPI;var component=renderer.create(React.createElement(NavigationContext.Provider,{value:navigation,__source:{fileName:_jsxFileName,lineNumber:83}},React.createElement(NavigationEvents,{__source:{fileName:_jsxFileName,lineNumber:84}})));expect(NavigationListenersAPI.get('willFocus').length).toBe(1);expect(NavigationListenersAPI.get('didFocus').length).toBe(1);expect(NavigationListenersAPI.get('willBlur').length).toBe(1);expect(NavigationListenersAPI.get('didBlur').length).toBe(1);component.unmount();expect(NavigationListenersAPI.get('willFocus').length).toBe(0);expect(NavigationListenersAPI.get('didFocus').length).toBe(0);expect(NavigationListenersAPI.get('willBlur').length).toBe(0);expect(NavigationListenersAPI.get('didBlur').length).toBe(0);});it('wire props listeners to navigation listeners',function(){var _createTestNavigation3=createTestNavigationAndHelpers(),navigation=_createTestNavigation3.navigation,NavigationListenersAPI=_createTestNavigation3.NavigationListenersAPI;var eventListenerProps=createEventListenersProp();renderer.create(React.createElement(NavigationEvents,_extends({navigation:navigation},eventListenerProps,{__source:{fileName:_jsxFileName,lineNumber:108}})));var checkPropListenerIsCalled=function checkPropListenerIsCalled(eventName,propName){expect(eventListenerProps[propName]).toHaveBeenCalledTimes(0);NavigationListenersAPI.call(eventName);expect(eventListenerProps[propName]).toHaveBeenCalledTimes(1);};checkPropListenerIsCalled('willFocus','onWillFocus');checkPropListenerIsCalled('didFocus','onDidFocus');checkPropListenerIsCalled('willBlur','onWillBlur');checkPropListenerIsCalled('didBlur','onDidBlur');});it('wire latest props listener to navigation listeners on updates (support closure/arrow functions update)',function(){var _createTestNavigation4=createTestNavigationAndHelpers(),navigation=_createTestNavigation4.navigation,NavigationListenersAPI=_createTestNavigation4.NavigationListenersAPI;var component=renderer.create(React.createElement(NavigationEvents,_extends({navigation:navigation},createEventListenersProp(),{__source:{fileName:_jsxFileName,lineNumber:130}})));component.update(React.createElement(NavigationEvents,{navigation:navigation,onWillBlur:function onWillBlur(){throw new Error('should not be called');},onDidFocus:function onDidFocus(){throw new Error('should not be called');},__source:{fileName:_jsxFileName,lineNumber:137}}));component.update(React.createElement(NavigationEvents,_extends({navigation:navigation},createEventListenersProp(),{__source:{fileName:_jsxFileName,lineNumber:149}})));var latestEventListenerProps=createEventListenersProp();component.update(React.createElement(NavigationEvents,_extends({navigation:navigation},latestEventListenerProps,{__source:{fileName:_jsxFileName,lineNumber:157}})));var checkLatestPropListenerCalled=function checkLatestPropListenerCalled(eventName,propName){expect(latestEventListenerProps[propName]).toHaveBeenCalledTimes(0);NavigationListenersAPI.call(eventName);expect(latestEventListenerProps[propName]).toHaveBeenCalledTimes(1);};checkLatestPropListenerCalled('willFocus','onWillFocus');checkLatestPropListenerCalled('didFocus','onDidFocus');checkLatestPropListenerCalled('willBlur','onWillBlur');checkLatestPropListenerCalled('didBlur','onDidBlur');});});
//# sourceMappingURL=NavigationEvents-test.js.map