'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var React = _interopRequireWildcard(_react);

var _deepmerge = require('deepmerge');

var _deepmerge2 = _interopRequireDefault(_deepmerge);

var _hoistNonReactStatics = require('hoist-non-react-statics');

var _hoistNonReactStatics2 = _interopRequireDefault(_hoistNonReactStatics);

var _utils = require('./utils');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj.default = obj; return newObj; } }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var isClassComponent = function isClassComponent(Component) {
  return Boolean(Component.prototype && Component.prototype.isReactComponent);
};

var createWithTheme = function createWithTheme(ThemeProvider, ThemeContext) {
  return function withTheme(Comp) {
    var ThemedComponent = function (_React$Component) {
      _inherits(ThemedComponent, _React$Component);

      function ThemedComponent() {
        var _ref;

        var _temp, _this, _ret;

        _classCallCheck(this, ThemedComponent);

        for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
          args[_key] = arguments[_key];
        }

        return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_ref = ThemedComponent.__proto__ || Object.getPrototypeOf(ThemedComponent)).call.apply(_ref, [this].concat(args))), _this), _this._merge = function (a, b) {
          var previous = _this._previous;

          if (previous && previous.a === a && previous.b === b) {
            return previous.result;
          }

          var result = a && b ? (0, _deepmerge2.default)(a, b) : a || b;

          _this._previous = { a: a, b: b, result: result };

          return result;
        }, _temp), _possibleConstructorReturn(_this, _ret);
      }
      /* $FlowFixMe */


      _createClass(ThemedComponent, [{
        key: 'render',
        value: function render() {
          var _this2 = this;

          var _props = this.props,
              forwardedRef = _props.forwardedRef,
              rest = _objectWithoutProperties(_props, ['forwardedRef']);

          return React.createElement(
            ThemeContext.Consumer,
            null,
            function (theme) {
              var merged = _this2._merge(theme, _this2.props.theme);

              var element = void 0;
              if (isClassComponent(Comp)) {
                // Only add refs for class components as function components don't support them
                // It's needed to support use cases which need access to the underlying node
                element = React.createElement(Comp, _extends({}, rest, {
                  ref: function ref(c) {
                    _this2._root = c;
                  },
                  theme: merged
                }));
              } else {
                element = React.createElement(Comp, _extends({}, rest, { theme: merged }));
              }

              if (merged !== _this2.props.theme) {
                // If a theme prop was passed, expose it to the children
                return React.createElement(
                  ThemeProvider,
                  { theme: merged },
                  element
                );
              }

              return element;
            }
          );
        }
      }]);

      return ThemedComponent;
    }(React.Component);

    ThemedComponent.displayName = 'withTheme(' + (Comp.displayName || Comp.name) + ')';


    var ComponentWithMethods = ThemedComponent;
    if (isClassComponent(Comp)) {
      // getWrappedInstance is exposed by some HOCs like react-redux's connect
      // Use it to get the ref to the underlying element
      // Also expose it to access the underlying element after wrapping
      // $FlowFixMe
      ComponentWithMethods.prototype.getWrappedInstance = function getWrappedInstance() {
        return this._root.getWrappedInstance ? this._root.getWrappedInstance() : this._root;
      };

      ComponentWithMethods = (0, _utils.copyRefs)(ComponentWithMethods, Comp);
    }

    (0, _hoistNonReactStatics2.default)(ComponentWithMethods, Comp);

    return ComponentWithMethods;
  };
};

exports.default = createWithTheme;