package com.commit451.gitlab.viewHolder

import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.TextView
import androidx.recyclerview.widget.RecyclerView
import com.commit451.addendum.recyclerview.bindView
import com.commit451.gitlab.R

/**
 * Shows the labels for an issue
 */
class IssueLabelViewHolder(view: View) : RecyclerView.ViewHolder(view) {

    companion object {

        fun inflate(parent: ViewGroup): IssueLabelViewHolder {
            val view = LayoutInflater.from(parent.context)
                .inflate(R.layout.item_issue_label, parent, false)
            return IssueLabelViewHolder(view)
        }
    }

    private val textTitle: TextView by bindView(R.id.title)

    fun bind(label: String) {
        textTitle.text = label
    }
}
