/*
 * Decompiled with CFR 0.152.
 */
package net.kazzz.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.kazzz.util.ArrayUtil;
import net.kazzz.util.IPredicate;

public final class FinderUtil {
    public static final <T> T find(T[] array, IPredicate<T> match) {
        T result = null;
        for (int i = 0; i < array.length; ++i) {
            T t = array[i];
            if (!match.evaluate(t)) continue;
            result = t;
            break;
        }
        return result;
    }

    public static final <T> T[] findAll(T[] array, IPredicate<T> match) {
        ArrayList<T> temp = new ArrayList<T>();
        int size = array.length;
        for (int i = 0; i < size; ++i) {
            T t = array[i];
            if (!match.evaluate(t)) continue;
            temp.add(t);
        }
        T[] result = ArrayUtil.copyOf(array, 0);
        return temp.toArray(result);
    }

    public static final <T> T find(Collection<T> list, IPredicate<T> match) {
        T result = null;
        for (T t : list) {
            if (!match.evaluate(t)) continue;
            result = t;
            break;
        }
        return result;
    }

    public static final <T> Collection<T> findAll(Collection<T> list, IPredicate<T> match) {
        ArrayList<T> temp = new ArrayList<T>();
        for (T t : list) {
            if (!match.evaluate(t)) continue;
            temp.add(t);
            break;
        }
        return temp;
    }

    public static final <T> T find(List<T> list, IPredicate<T> match) {
        T result = null;
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            T t = list.get(i);
            if (!match.evaluate(t)) continue;
            result = t;
            break;
        }
        return result;
    }

    public static final <T> List<T> findAll(List<T> list, IPredicate<T> match) {
        ArrayList<T> temp = new ArrayList<T>();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            T t = list.get(i);
            if (!match.evaluate(t)) continue;
            temp.add(t);
            break;
        }
        return temp;
    }

    public static <TValue> Iterator<Map.Entry<String, TValue>> findKeysWithPrefix(Map<String, TValue> dictionary, String prefix) {
        HashMap<String, TValue> map = new HashMap<String, TValue>();
        if (dictionary.containsKey(prefix)) {
            map.put(prefix, dictionary.get(prefix));
        }
        for (Map.Entry<String, TValue> entry : dictionary.entrySet()) {
            if (entry.getKey().length() <= prefix.length() || !entry.getKey().toLowerCase().startsWith(prefix)) continue;
            char charAfterPrefix = entry.getKey().charAt(prefix.length());
            switch (charAfterPrefix) {
                case '.': 
                case '[': {
                    map.put(entry.getKey(), entry.getValue());
                }
            }
        }
        return map.entrySet().iterator();
    }

    public static <TValue> boolean doesAnyKeyHavePrefix(Map<String, TValue> dictionary, String prefix) {
        return FinderUtil.findKeysWithPrefix(dictionary, prefix).hasNext();
    }
}

