/*
 * Decompiled with CFR 0.152.
 */
package net.kazzz.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.kazzz.util.FinderUtil;
import net.kazzz.util.IPredicate;

public final class ArrayUtil {
    public static final <T> T[] add(T[] array, T obj) {
        if (array == null) {
            throw new IllegalArgumentException("array");
        }
        Object[] newArray = (Object[])Array.newInstance(array.getClass().getComponentType(), array.length + 1);
        System.arraycopy(array, 0, newArray, 0, array.length);
        newArray[array.length] = obj;
        return newArray;
    }

    public static final <T> T[] add(T[] a, T[] b) {
        if (a != null && b != null) {
            if (a.length != 0 && b.length != 0) {
                Object[] array = (Object[])Array.newInstance(a.getClass().getComponentType(), a.length + b.length);
                System.arraycopy(a, 0, array, 0, a.length);
                System.arraycopy(b, 0, array, a.length, b.length);
                return array;
            }
            if (b.length == 0) {
                return a;
            }
            return b;
        }
        if (b == null) {
            return a;
        }
        return b;
    }

    public static final <T> int indexOf(T[] array, T obj) {
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                T o = array[i];
                if (!(o != null ? o.equals(obj) : obj == null)) continue;
                return i;
            }
        }
        return -1;
    }

    public static final int indexOfIgnoreCase(String[] array, String str) {
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                String s = array[i];
                if (!(s != null ? s.equalsIgnoreCase(str) : str == null)) continue;
                return i;
            }
        }
        return -1;
    }

    public static final int indexOf(char[] array, char ch) {
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                char c = array[i];
                if (ch != c) continue;
                return i;
            }
        }
        return -1;
    }

    public static final <T> T[] remove(T[] array, T obj) {
        int index = ArrayUtil.indexOf(array, obj);
        if (index < 0) {
            return array;
        }
        Object[] newArray = (Object[])Array.newInstance(array.getClass().getComponentType(), array.length - 1);
        if (index > 0) {
            System.arraycopy(array, 0, newArray, 0, index);
        }
        if (index < array.length - 1) {
            System.arraycopy(array, index + 1, newArray, index, newArray.length - index);
        }
        return newArray;
    }

    public static final boolean isEmpty(Object[] arrays) {
        return arrays == null || arrays.length == 0;
    }

    public static final <T> boolean contains(T[] array, T obj) {
        return -1 < ArrayUtil.indexOf(array, obj);
    }

    public static final boolean containsIgnoreCase(String[] array, String str) {
        return -1 < ArrayUtil.indexOfIgnoreCase(array, str);
    }

    public static final boolean contains(char[] array, char ch) {
        return -1 < ArrayUtil.indexOf(array, ch);
    }

    public static final <T> boolean equalsIgnoreSequence(T[] array1, T[] array2) {
        if (array1 == null && array2 == null) {
            return true;
        }
        if (array1 == null || array2 == null) {
            return false;
        }
        if (array1.length != array2.length) {
            return false;
        }
        List<T> list = Arrays.asList(array2);
        for (int i = 0; i < array1.length; ++i) {
            T o1 = array1[i];
            if (list.contains(o1)) continue;
            return false;
        }
        return true;
    }

    public static final String toString(Object[] array) {
        if (array == null) {
            return "null";
        }
        if (array.length == 0) {
            return "[]";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            if (i == 0) {
                sb.append('[');
            } else {
                sb.append(", ");
            }
            sb.append(String.valueOf(array[i]));
        }
        sb.append("]");
        return sb.toString();
    }

    public static final Object[] toObjectArray(Object obj) {
        int length = Array.getLength(obj);
        Object[] array = new Object[length];
        for (int i = 0; i < length; ++i) {
            array[i] = Array.get(obj, i);
        }
        return array;
    }

    public static final String[] trim(String[] array) {
        String[] includes = FinderUtil.findAll(array, new IPredicate<String>(){

            @Override
            public boolean evaluate(String input) {
                return input != null && input.length() > 0;
            }
        });
        return includes;
    }

    public static final <T> T[] truncate(T[] array) {
        final ArrayList list = new ArrayList(array.length);
        T[] includes = FinderUtil.findAll(array, new IPredicate<T>(){

            @Override
            public boolean evaluate(T input) {
                if (list.contains(input)) {
                    return false;
                }
                list.add(input);
                return true;
            }
        });
        return includes;
    }

    public static final <T> T[] copyOf(T[] original, int newLength) {
        return ArrayUtil.copyOf(original, newLength, original.getClass());
    }

    public static final <T, U> T[] copyOf(U[] original, int newLength, Class<? extends T[]> newType) {
        Object[] copy = newType == Object[].class ? new Object[newLength] : (Object[])Array.newInstance(newType.getComponentType(), newLength);
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }
}

