/*
 * Decompiled with CFR 0.152.
 */
package net.kazzz.felica.lib;

import java.nio.ByteBuffer;
import java.util.Arrays;

public final class Util {
    private Util() {
    }

    public static byte[] toBytes(int a) {
        byte[] bs = new byte[4];
        bs[3] = (byte)(0xFF & a);
        bs[2] = (byte)(0xFF & a >>> 8);
        bs[1] = (byte)(0xFF & a >>> 16);
        bs[0] = (byte)(0xFF & a >>> 24);
        return bs;
    }

    public static int toInt(byte ... b) {
        if (b == null || b.length == 0) {
            throw new IllegalArgumentException();
        }
        if (b.length == 1) {
            return b[0] & 0xFF;
        }
        if (b.length == 2) {
            int i = 0;
            i |= b[0] & 0xFF;
            i <<= 8;
            return i |= b[1] & 0xFF;
        }
        if (b.length == 3) {
            int i = 0;
            i |= b[0] & 0xFF;
            i <<= 8;
            i |= b[1] & 0xFF;
            i <<= 8;
            return i |= b[2] & 0xFF;
        }
        return ByteBuffer.wrap(b).getInt();
    }

    public static String getHexString(byte data) {
        return Util.getHexString(new byte[]{data}, new int[0]);
    }

    public static String getHexString(byte[] byteArray, int ... split) {
        StringBuilder builder = new StringBuilder();
        byte[] target = null;
        target = split.length <= 1 ? byteArray : (split.length < 2 ? Arrays.copyOfRange(byteArray, 0, 0 + split[0]) : Arrays.copyOfRange(byteArray, split[0], split[0] + split[1]));
        for (byte b : target) {
            builder.append(String.format("%02x", b).toUpperCase());
        }
        return builder.toString();
    }

    public static String getBinString(byte data) {
        return Util.getBinString(new byte[]{data}, new int[0]);
    }

    public static String getBinString(byte[] byteArray, int ... split) {
        StringBuilder builder = new StringBuilder();
        byte[] target = null;
        target = split.length <= 1 ? byteArray : (split.length < 2 ? Arrays.copyOfRange(byteArray, 0, 0 + split[0]) : Arrays.copyOfRange(byteArray, split[0], split[0] + split[1]));
        for (byte b : target) {
            builder.append(String.format("%8s", Integer.toBinaryString(b & 0xFF)).replaceAll(" ", "0"));
        }
        return builder.toString();
    }
}

