/*
 * Decompiled with CFR 0.152.
 */
package net.kazzz.felica.lib;

import android.nfc.Tag;
import android.nfc.TagLostException;
import android.nfc.tech.NfcF;
import android.os.Parcel;
import android.os.Parcelable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.kazzz.felica.FeliCaException;
import net.kazzz.felica.IFeliCaByteData;
import net.kazzz.felica.command.IFeliCaCommand;
import net.kazzz.felica.lib.Util;
import net.kazzz.nfc.NfcException;

public final class FeliCaLib {
    static final String TAG = "FeliCaLib";
    public static final byte COMMAND_POLLING = 0;
    public static final byte RESPONSE_POLLING = 1;
    public static final byte COMMAND_REQUEST_SERVICE = 2;
    public static final byte RESPONSE_REQUEST_SERVICE = 3;
    public static final byte COMMAND_REQUEST_RESPONSE = 4;
    public static final byte RESPONSE_REQUEST_RESPONSE = 5;
    public static final byte COMMAND_READ_WO_ENCRYPTION = 6;
    public static final byte RESPONSE_READ_WO_ENCRYPTION = 7;
    public static final byte COMMAND_WRITE_WO_ENCRYPTION = 8;
    public static final byte RESPONSE_WRITE_WO_ENCRYPTION = 9;
    public static final byte COMMAND_SEARCH_SERVICECODE = 10;
    public static final byte RESPONSE_SEARCH_SERVICECODE = 11;
    public static final byte COMMAND_REQUEST_SYSTEMCODE = 12;
    public static final byte RESPONSE_REQUEST_SYSTEMCODE = 13;
    public static final byte COMMAND_AUTHENTICATION1 = 16;
    public static final byte RESPONSE_AUTHENTICATION1 = 17;
    public static final byte COMMAND_AUTHENTICATION2 = 18;
    public static final byte RESPONSE_AUTHENTICATION2 = 19;
    public static final byte COMMAND_READ = 20;
    public static final byte RESPONSE_READ = 21;
    public static final byte COMMAND_WRITE = 22;
    public static final byte RESPONSE_WRITE = 23;
    public static final int SYSTEMCODE_ANY = 65535;
    public static final int SYSTEMCODE_FELICA_LITE = 34996;
    public static final int SYSTEMCODE_COMMON = 65024;
    public static final int SYSTEMCODE_CYBERNE = 3;
    public static final int SYSTEMCODE_EDY = 65024;
    public static final int SYSTEMCODE_SUICA = 3;
    public static final int SYSTEMCODE_PASMO = 3;
    public static final int SERVICE_SUICA_INOUT = 4239;
    public static final int SERVICE_SUICA_HISTORY = 2319;
    public static final int SERVICE_FELICA_LITE_READONLY = 2816;
    public static final int SERVICE_FELICA_LITE_READWRITE = 2304;
    public static final int RANDOM_RW_AUTH = 8;
    public static final int RANDOM_RW_WOAUTH = 9;
    public static final int RANDOM_RO_AUTH = 10;
    public static final int RANDOM_RO_WOAUTH = 11;
    public static final int CYCLIC_RW_AUTH = 12;
    public static final int CYCLIC_RW_WOAUTH = 13;
    public static final int CYCLIC_RO_AUTH = 14;
    public static final int CYCLIC_RO_WOAUTH = 15;
    public static final int PARSE_DR_AUTH = 16;
    public static final int PARSE_DR_WOAUTH = 17;
    public static final int PARSE_CB_DEC_AUTH = 18;
    public static final int PARSE_CB_DEC_WOAUTH = 19;
    public static final int PARSE_DEC_AUTH = 20;
    public static final int PARSE_DEC_WOAUTH = 21;
    public static final int PARSE_RO_AUTH = 22;
    public static final int PARSE_RO_WOAUTH = 23;
    public static final int STATUSFLAG1_NORMAL = 0;
    public static final int STATUSFLAG1_ERROR = 255;
    public static final int STATUSFLAG2_NORMAL = 0;
    public static final int STATUSFLAG2_ERROR_LENGTH = 1;
    public static final int STATUSFLAG2_ERROR_FLOWN = 2;
    public static final int STATUSFLAG2_ERROR_MEMORY = 112;
    public static final int STATUSFLAG2_ERROR_WRITELIMIT = 113;
    public static final Map<Byte, String> commandMap = new HashMap<Byte, String>();

    public static final CommandResponse execute(Tag tag, CommandPacket commandPacket) throws FeliCaException {
        byte[] result = FeliCaLib.executeRaw(tag, commandPacket.getBytes());
        return new CommandResponse(result);
    }

    public static final byte[] executeRaw(Tag tag, byte[] data) throws FeliCaException {
        try {
            return FeliCaLib.transceive(tag, data);
        }
        catch (NfcException e) {
            throw new FeliCaException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] transceive(Tag tag, byte[] data) throws NfcException {
        byte[] byArray;
        NfcF nfcF = NfcF.get((Tag)tag);
        if (nfcF == null) {
            throw new NfcException("tag is not FeliCa(NFC-F) ");
        }
        nfcF.connect();
        try {
            byArray = nfcF.transceive(data);
        }
        catch (Throwable throwable) {
            try {
                nfcF.close();
                throw throwable;
            }
            catch (TagLostException e) {
                return null;
            }
            catch (IOException e) {
                throw new NfcException(e);
            }
        }
        nfcF.close();
        return byArray;
    }

    static {
        commandMap.put((byte)0, "Polling");
        commandMap.put((byte)1, "Polling(responce)");
        commandMap.put((byte)2, "Request Service");
        commandMap.put((byte)3, "Request Service(response)");
        commandMap.put((byte)4, "Request Response");
        commandMap.put((byte)5, "Request Response(response)");
        commandMap.put((byte)6, "Read Without Encryption");
        commandMap.put((byte)7, "Read Without Encryption(response)");
        commandMap.put((byte)8, "Write Without Encryption");
        commandMap.put((byte)9, "Write Without Encryption(response)");
        commandMap.put((byte)10, "Search Service");
        commandMap.put((byte)11, "Search Service(response)");
        commandMap.put((byte)12, "Request System Code");
        commandMap.put((byte)13, "Request System Code(response)");
        commandMap.put((byte)16, "Authentication1");
        commandMap.put((byte)17, "Authentication1(response)");
        commandMap.put((byte)18, "Authentication2");
        commandMap.put((byte)19, "Authentication2(response)");
        commandMap.put((byte)20, "Read");
        commandMap.put((byte)21, "Read(response)");
        commandMap.put((byte)22, "Write");
        commandMap.put((byte)23, "Write(response)");
    }

    public static class MemoryConfigurationBlock
    extends Block
    implements IFeliCaByteData {
        public MemoryConfigurationBlock(byte[] mcData) {
            super(mcData);
        }

        public boolean isNdefSupport() {
            if (this.data == null) {
                return false;
            }
            return (this.data[3] & 0xFFFFFFFF) == 1;
        }

        public void setNdefSupport(boolean ndefSupport) {
            this.data[3] = (byte)(ndefSupport ? 1 : 0);
        }

        public boolean isWritable(int ... addrs) {
            if (this.data == null) {
                return false;
            }
            boolean result = true;
            for (int a : addrs) {
                byte b = (byte)((a & 0xFF) + 1);
                if (a < 8) {
                    result &= (this.data[0] & b) == b;
                    continue;
                }
                if (a < 16) {
                    result &= (this.data[1] & b) == b;
                    continue;
                }
                result &= (this.data[2] & b) == b;
            }
            return result;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("\u30e1\u30e2\u30ea\u30b3\u30f3\u30d5\u30a3\u30b0\u30ec\u30fc\u30b7\u30e7\u30f3\u30d6\u30ed\u30c3\u30af(MC)\n");
            sb.append("  NdefSupport  : " + this.isNdefSupport() + "\n");
            sb.append("  MemoryConfig : \n");
            for (int i = 0; i < this.data.length; ++i) {
                sb.append("    \u30d6\u30ed\u30c3\u30af  " + i + " = " + (this.isWritable(i) ? "1:RW" : "0:RO") + "\n");
            }
            return sb.toString();
        }
    }

    public static class BlockListElement
    implements IFeliCaByteData {
        public static final byte LENGTH_2_BYTE = -128;
        public static final byte LENGTH_3_BYTE = 0;
        public static final byte ACCESSMODE_DECREMENT = 0;
        public static final byte ACCESSMODE_CACHEBACK = 1;
        final byte lengthAndaccessMode;
        final byte serviceCodeListOrder;
        final byte[] blockNumber;

        public BlockListElement(byte accessMode, byte serviceCodeListOrder, byte ... blockNumber) {
            this.lengthAndaccessMode = blockNumber.length > 1 ? (byte)(accessMode | 0x80) : (byte)(accessMode | 0);
            this.serviceCodeListOrder = (byte)(serviceCodeListOrder & 0xF);
            this.blockNumber = blockNumber;
        }

        @Override
        public byte[] getBytes() {
            if ((this.lengthAndaccessMode & 0xFFFFFF80) == 1) {
                ByteBuffer buff = ByteBuffer.allocate(2);
                buff.put((byte)((this.lengthAndaccessMode | this.serviceCodeListOrder) & 0xFF)).put(this.blockNumber[0]);
                return buff.array();
            }
            ByteBuffer buff = ByteBuffer.allocate(3);
            buff.put((byte)((this.lengthAndaccessMode | this.serviceCodeListOrder) & 0xFF)).put(this.blockNumber[1]).put(this.blockNumber[0]);
            return buff.array();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("\u30d6\u30ed\u30c3\u30af\u30ea\u30b9\u30c8\u30a8\u30ec\u30e1\u30f3\u30c8\n");
            sb.append("  \u30c7\u30fc\u30bf\u9577 : " + this.getBytes().length + " byte\n");
            sb.append("  \u30a2\u30af\u30bb\u30b9\u30e2\u30fc\u30c9        : " + Util.getBinString((byte)(this.lengthAndaccessMode & 0x8F)) + "\n");
            sb.append("  \u30b5\u30fc\u30d3\u30b9\u30b3\u30fc\u30c9\u30ea\u30b9\u30c8\u9806: " + Util.getHexString(this.serviceCodeListOrder) + "\n");
            sb.append("  \u30d6\u30ed\u30c3\u30af\u30ca\u30f3\u30d0\u30fc      : " + Util.getHexString(this.blockNumber, new int[0]) + "\n");
            return sb.toString();
        }
    }

    public static class Block
    implements IFeliCaByteData {
        final byte[] data;

        public Block() {
            this.data = new byte[16];
        }

        public Block(byte[] data) {
            this.data = data;
        }

        @Override
        public byte[] getBytes() {
            return this.data;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("\u30d6\u30ed\u30c3\u30af : " + Util.getHexString(this.data, new int[0]) + "\n");
            return sb.toString();
        }
    }

    public static class Service
    implements IFeliCaByteData {
        final ServiceCode[] serviceCodes;
        final BlockListElement[] blockListElements;

        public Service(ServiceCode[] serviceCodes, BlockListElement ... blockListElements) {
            this.serviceCodes = serviceCodes;
            this.blockListElements = blockListElements;
        }

        @Override
        public byte[] getBytes() {
            int length = 0;
            for (ServiceCode s : this.serviceCodes) {
                length += s.getBytes().length;
            }
            for (BlockListElement b : this.blockListElements) {
                length += b.getBytes().length;
            }
            ByteBuffer buff = ByteBuffer.allocate(length);
            for (ServiceCode s : this.serviceCodes) {
                buff.put(s.getBytes());
            }
            for (BlockListElement b : this.blockListElements) {
                buff.put(b.getBytes());
            }
            return buff.array();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (ServiceCode s : this.serviceCodes) {
                sb.append(s.toString());
            }
            for (BlockListElement b : this.blockListElements) {
                sb.append(b.toString());
            }
            return sb.toString();
        }
    }

    public static class ServiceCode {
        final byte[] serviceCode;
        final byte[] serviceCodeLE;

        public ServiceCode(byte[] bytes) {
            this.serviceCode = bytes;
            this.serviceCodeLE = (byte[])(bytes.length == 2 ? new byte[]{bytes[1], bytes[0]} : null);
        }

        public ServiceCode(int serviceCode) {
            this(new byte[]{(byte)(serviceCode & 0xFF), (byte)(serviceCode >> 8)});
        }

        public byte[] getBytes() {
            return this.serviceCode;
        }

        public boolean encryptNeeded() {
            boolean ret = false;
            if (this.serviceCodeLE != null) {
                ret = (this.serviceCodeLE[1] & 1) == 0;
            }
            return ret;
        }

        public boolean isWritable() {
            boolean ret = false;
            if (this.serviceCodeLE != null) {
                int accessInfo = this.serviceCodeLE[1] & 0x3F;
                ret = (accessInfo & 2) == 0 || accessInfo == 19 || accessInfo == 18;
            }
            return ret;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(Util.getHexString(this.serviceCodeLE, new int[0]));
            if (this.serviceCodeLE != null) {
                int accessInfo = this.serviceCodeLE[1] & 0x3F;
                switch (accessInfo) {
                    case 9: {
                        sb.append(" \u56fa\u5b9a\u9577RW");
                        break;
                    }
                    case 11: {
                        sb.append(" \u56fa\u5b9a\u9577RO");
                        break;
                    }
                    case 13: {
                        sb.append(" \u5faa\u74b0RW");
                        break;
                    }
                    case 15: {
                        sb.append(" \u5faa\u74b0RO");
                        break;
                    }
                    case 17: {
                        sb.append(" \u52a0\u6e1b\u7b97\u76f4\u63a5");
                        break;
                    }
                    case 19: {
                        sb.append(" \u52a0\u6e1b\u7b97\u623b\u5165");
                        break;
                    }
                    case 21: {
                        sb.append(" \u52a0\u6e1b\u7b97\u6e1b\u7b97");
                        break;
                    }
                    case 23: {
                        sb.append(" \u52a0\u6e1b\u7b97RO");
                        break;
                    }
                    case 8: {
                        sb.append(" \u56fa\u5b9a\u9577RW(Locked)");
                        break;
                    }
                    case 10: {
                        sb.append(" \u56fa\u5b9a\u9577RO(Locked)");
                        break;
                    }
                    case 12: {
                        sb.append(" \u5faa\u74b0RW(Locked)");
                        break;
                    }
                    case 14: {
                        sb.append(" \u5faa\u74b0RO(Locked)");
                        break;
                    }
                    case 16: {
                        sb.append(" \u52a0\u6e1b\u7b97\u76f4\u63a5(Locked)");
                        break;
                    }
                    case 18: {
                        sb.append(" \u52a0\u6e1b\u7b97\u623b\u5165(Locked)");
                        break;
                    }
                    case 20: {
                        sb.append(" \u52a0\u6e1b\u7b97\u6e1b\u7b97(Locked)");
                        break;
                    }
                    case 22: {
                        sb.append(" \u52a0\u6e1b\u7b97RO(Locked)");
                    }
                }
            }
            return sb.toString();
        }
    }

    public static class SystemCode
    implements IFeliCaByteData {
        final byte[] systemCode;

        public SystemCode(byte[] bytes) {
            this.systemCode = bytes;
        }

        @Override
        public byte[] getBytes() {
            return this.systemCode;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("\u30b7\u30b9\u30c6\u30e0\u30b3\u30fc\u30c9 : " + Util.getHexString(this.systemCode, new int[0]) + "\n");
            return sb.toString();
        }
    }

    public static class PMm
    implements Parcelable,
    IFeliCaByteData {
        public static final Parcelable.Creator<PMm> CREATOR = new Parcelable.Creator<PMm>(){

            public PMm createFromParcel(Parcel in) {
                return new PMm(in);
            }

            public PMm[] newArray(int size) {
                return new PMm[size];
            }
        };
        final byte[] icCode;
        final byte[] maximumResponseTime;

        public PMm(Parcel in) {
            this.icCode = new byte[in.readInt()];
            in.readByteArray(this.icCode);
            this.maximumResponseTime = new byte[in.readInt()];
            in.readByteArray(this.maximumResponseTime);
        }

        public PMm(byte[] bytes) {
            this.icCode = new byte[]{bytes[0], bytes[1]};
            this.maximumResponseTime = new byte[]{bytes[2], bytes[3], bytes[4], bytes[5], bytes[6], bytes[7]};
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.icCode.length);
            dest.writeByteArray(this.icCode);
            dest.writeInt(this.maximumResponseTime.length);
            dest.writeByteArray(this.maximumResponseTime);
        }

        @Override
        public byte[] getBytes() {
            ByteBuffer buff = ByteBuffer.allocate(this.icCode.length + this.maximumResponseTime.length);
            buff.put(this.icCode).put(this.maximumResponseTime);
            return buff.array();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("PMm(\u88fd\u9020\u30d1\u30e9\u30e1\u30fc\u30bf)\n");
            sb.append(" IC\u30b3\u30fc\u30c9(2byte): " + Util.getHexString(this.icCode, new int[0]) + "\n");
            sb.append("   ROM\u7a2e\u5225: " + Util.getHexString(this.icCode, 0, 1) + "\n");
            sb.append("   IC \u7a2e\u5225: " + Util.getHexString(this.icCode, 1, 1) + "\n");
            sb.append("\n");
            sb.append(" \u6700\u5927\u5fdc\u7b54\u6642\u9593\u30d1\u30e9\u30e1\u30bf(6byte)\n");
            sb.append("  B3(request service):" + Util.getBinString(this.maximumResponseTime, 0, 1) + "\n");
            sb.append("  B4(request response):" + Util.getBinString(this.maximumResponseTime, 1, 1) + "\n");
            sb.append("  B5(authenticate):" + Util.getBinString(this.maximumResponseTime, 2, 1) + "\n");
            sb.append("  B6(read):" + Util.getBinString(this.maximumResponseTime, 3, 1) + "\n");
            sb.append("  B7(write):" + Util.getBinString(this.maximumResponseTime, 4, 1) + "\n");
            sb.append("  B8():" + Util.getBinString(this.maximumResponseTime, 5, 1) + "\n");
            return sb.toString();
        }
    }

    public static class IDm
    implements Parcelable,
    IFeliCaByteData {
        public static final Parcelable.Creator<IDm> CREATOR = new Parcelable.Creator<IDm>(){

            public IDm createFromParcel(Parcel in) {
                return new IDm(in);
            }

            public IDm[] newArray(int size) {
                return new IDm[size];
            }
        };
        final byte[] manufactureCode;
        final byte[] cardIdentification;

        public IDm(Parcel in) {
            this.manufactureCode = new byte[in.readInt()];
            in.readByteArray(this.manufactureCode);
            this.cardIdentification = new byte[in.readInt()];
            in.readByteArray(this.cardIdentification);
        }

        public IDm(byte[] bytes) {
            this.manufactureCode = new byte[]{bytes[0], bytes[1]};
            this.cardIdentification = new byte[]{bytes[2], bytes[3], bytes[4], bytes[5], bytes[6], bytes[7]};
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.manufactureCode.length);
            dest.writeByteArray(this.manufactureCode);
            dest.writeInt(this.cardIdentification.length);
            dest.writeByteArray(this.cardIdentification);
        }

        @Override
        public byte[] getBytes() {
            ByteBuffer buff = ByteBuffer.allocate(this.manufactureCode.length + this.cardIdentification.length);
            buff.put(this.manufactureCode).put(this.cardIdentification);
            return buff.array();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("IDm (8byte) : " + Util.getHexString(this.getBytes(), new int[0]) + "\n");
            sb.append(" \u88fd\u9020\u8005\u30b3\u30fc\u30c9: " + Util.getHexString(this.manufactureCode, new int[0]) + "\n");
            sb.append(" \u30ab\u30fc\u30c9\u8b58\u5225\u756a\u53f7:\n");
            sb.append("   \u88fd\u9020\u5668:" + Util.getHexString(this.cardIdentification, 0, 2) + "\n");
            sb.append("   \u65e5\u4ed8:" + Util.getHexString(this.cardIdentification, 2, 2) + "\n");
            sb.append("   \u30b7\u30ea\u30a2\u30eb:" + Util.getHexString(this.cardIdentification, 4, 2) + "\n");
            return sb.toString();
        }
    }

    public static class CommandResponse
    implements IFeliCaCommand {
        protected final byte[] rawData;
        protected final int length;
        protected final byte responseCode;
        protected final IDm idm;
        protected final byte[] data;

        public CommandResponse(CommandResponse response) {
            this(response != null ? response.getBytes() : null);
        }

        public CommandResponse(byte[] data) {
            if (data != null) {
                this.rawData = data;
                this.length = data[0] & 0xFF;
                this.responseCode = data[1];
                this.idm = new IDm(Arrays.copyOfRange(data, 2, 10));
                this.data = Arrays.copyOfRange(data, 10, data.length);
            } else {
                this.rawData = null;
                this.length = 0;
                this.responseCode = 0;
                this.idm = null;
                this.data = null;
            }
        }

        @Override
        public IDm getIDm() {
            return this.idm;
        }

        @Override
        public byte[] getBytes() {
            return this.rawData;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(" \n\n");
            sb.append("FeliCa \u30ec\u30b9\u30dd\u30f3\u30b9\u30d1\u30b1\u30c3\u30c8 \n");
            sb.append(" \u30b3\u30de\u30f3\u30c9\u540d:" + commandMap.get(this.responseCode) + "\n");
            sb.append(" \u30c7\u30fc\u30bf\u9577: " + Util.getHexString((byte)(this.length & 0xFF)) + "\n");
            sb.append(" \u30ec\u30b9\u30dd\u30f3\u30b9\u30b3\u30fc\u30c9: " + Util.getHexString(this.responseCode) + "\n");
            sb.append(" " + this.idm.toString() + "\n");
            sb.append(" \u30c7\u30fc\u30bf: " + Util.getHexString(this.data, new int[0]) + "\n");
            return sb.toString();
        }
    }

    public static class CommandPacket
    implements IFeliCaCommand {
        protected final int length;
        protected final byte commandCode;
        protected final IDm idm;
        protected final byte[] data;

        public CommandPacket(CommandPacket command) throws FeliCaException {
            this(command.getBytes());
        }

        public CommandPacket(byte[] data) throws FeliCaException {
            this(data[0], Arrays.copyOfRange(data, 1, data.length));
        }

        public CommandPacket(byte commandCode, byte ... data) throws FeliCaException {
            if (!commandMap.containsKey(commandCode)) {
                throw new FeliCaException("commandCode : " + commandCode + " not supported.");
            }
            this.commandCode = commandCode;
            if (data.length >= 8) {
                this.idm = new IDm(Arrays.copyOfRange(data, 0, 8));
                this.data = Arrays.copyOfRange(data, 8, data.length);
            } else {
                this.idm = null;
                this.data = Arrays.copyOfRange(data, 0, data.length);
            }
            this.length = data.length + 2;
            if (this.length > 255) {
                throw new FeliCaException("command data too long (less than 255Byte)");
            }
        }

        public CommandPacket(byte commandCode, IDm idm, byte ... data) throws FeliCaException {
            if (!commandMap.containsKey(commandCode)) {
                throw new FeliCaException("commandCode : " + commandCode + " not supported.");
            }
            this.commandCode = commandCode;
            this.idm = idm;
            this.data = data;
            this.length = idm.getBytes().length + data.length + 2;
            if (this.length > 255) {
                throw new FeliCaException("command data too long (less than 255byte)");
            }
        }

        public CommandPacket(byte commandCode, byte[] idm, byte ... data) throws FeliCaException {
            if (!commandMap.containsKey(commandCode)) {
                throw new FeliCaException("commandCode : " + commandCode + " not supported.");
            }
            this.commandCode = commandCode;
            this.idm = new IDm(idm);
            this.data = data;
            this.length = idm.length + data.length + 2;
            if (this.length > 255) {
                throw new FeliCaException("command data too long (less than 255byte)");
            }
        }

        @Override
        public IDm getIDm() {
            return this.idm;
        }

        @Override
        public byte[] getBytes() {
            ByteBuffer buff = ByteBuffer.allocate(this.length);
            byte length = (byte)this.length;
            if (this.idm != null) {
                buff.put(length).put(this.commandCode).put(this.idm.getBytes()).put(this.data);
            } else {
                buff.put(length).put(this.commandCode).put(this.data);
            }
            return buff.array();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("FeliCa \u30b3\u30de\u30f3\u30c9\u30d1\u30b1\u30c3\u30c8 \n");
            sb.append(" \u30b3\u30de\u30f3\u30c9\u540d:" + commandMap.get(this.commandCode) + "\n");
            sb.append(" \u30c7\u30fc\u30bf\u9577: " + Util.getHexString((byte)(this.length & 0xFF)) + "\n");
            sb.append(" \u30b3\u30de\u30f3\u30c9\u30b3\u30fc\u30c9 : " + Util.getHexString(this.commandCode) + "\n");
            if (this.idm != null) {
                sb.append(" " + this.idm.toString() + "\n");
            }
            sb.append(" \u30c7\u30fc\u30bf: " + Util.getHexString(this.data, new int[0]) + "\n");
            return sb.toString();
        }
    }
}

