/*
 * Decompiled with CFR 0.152.
 */
package net.kazzz.felica.command;

import java.util.Arrays;
import net.kazzz.felica.lib.FeliCaLib;
import net.kazzz.felica.lib.Util;

public class ReadResponse
extends FeliCaLib.CommandResponse {
    final int statusFlag1;
    final int statusFlag2;
    final int blockCount;
    final byte[] blockData;

    public ReadResponse(FeliCaLib.CommandResponse response) {
        super(response);
        this.statusFlag1 = this.data[0];
        this.statusFlag2 = this.data[1];
        if (this.getStatusFlag1() == 0) {
            this.blockCount = this.data[2];
            this.blockData = Arrays.copyOfRange(this.data, 3, this.data.length);
        } else {
            this.blockCount = 0;
            this.blockData = null;
        }
    }

    public int getStatusFlag1() {
        return this.statusFlag1;
    }

    public int getStatusFlag2() {
        return this.statusFlag2;
    }

    public byte[] getBlockData() {
        return this.blockData;
    }

    public int getBlockCount() {
        return this.blockCount;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("FeliCa Read Response \n");
        sb.append(" \u30b3\u30de\u30f3\u30c9\u540d : " + FeliCaLib.commandMap.get(this.responseCode) + "\n");
        sb.append(" \u30c7\u30fc\u30bf\u9577 : " + this.length + "\n");
        sb.append(" \u30b3\u30de\u30f3\u30c9\u30b3\u30fc\u30c9 : " + Util.getHexString(this.responseCode) + "\n");
        if (this.idm != null) {
            sb.append(" " + this.idm.toString() + "\n");
        }
        sb.append(" \u30b9\u30c6\u30fc\u30bf\u30b9\u30d5\u30e9\u30b01 : " + Util.getHexString((byte)(this.statusFlag1 & 0xFF)) + "\n");
        sb.append(" \u30b9\u30c6\u30fc\u30bf\u30b9\u30d5\u30e9\u30b02 : " + Util.getHexString((byte)(this.statusFlag2 & 0xFF)) + "\n");
        if (this.blockData != null) {
            sb.append(" \u30d6\u30ed\u30c3\u30af\u30c7\u30fc\u30bf:  " + Util.getHexString(this.blockData, new int[0]) + "\n");
        }
        return sb.toString();
    }
}

