/*
 * Decompiled with CFR 0.152.
 */
package net.kazzz.felica.command;

import java.util.Arrays;
import net.kazzz.felica.lib.FeliCaLib;
import net.kazzz.felica.lib.Util;

public class PollingResponse
extends FeliCaLib.CommandResponse {
    final FeliCaLib.PMm pmm;
    final byte[] requestData;

    public PollingResponse(FeliCaLib.CommandResponse response) {
        super(response);
        if (this.data != null && this.data.length >= 8) {
            this.pmm = new FeliCaLib.PMm(Arrays.copyOfRange(this.data, 0, 8));
            this.requestData = Arrays.copyOfRange(this.data, 8, this.data.length);
        } else {
            this.pmm = null;
            this.requestData = null;
        }
    }

    public FeliCaLib.PMm getPMm() {
        return this.pmm;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("FeliCa \u30ec\u30b9\u30dd\u30f3\u30b9\u3000\u30d1\u30b1\u30c3\u30c8 \n");
        sb.append(" \u30b3\u30de\u30f3\u30c9\u540d : " + FeliCaLib.commandMap.get(this.responseCode) + "\n");
        sb.append(" \u30c7\u30fc\u30bf\u9577 : " + this.length + "\n");
        sb.append(" \u30b3\u30de\u30f3\u30c9\u30b3\u30fc\u30c9 : " + Util.getHexString(this.responseCode) + "\n");
        if (this.idm != null) {
            sb.append(" " + this.idm.toString() + "\n");
        }
        if (this.pmm != null) {
            sb.append(" " + this.pmm.toString() + "\n");
        }
        sb.append(" \u30c7\u30fc\u30bf: " + Util.getHexString(this.data, new int[0]) + "\n");
        return sb.toString();
    }
}

