/*
 * Decompiled with CFR 0.152.
 */
package net.kazzz.felica;

import android.nfc.Tag;
import android.os.Parcel;
import android.os.Parcelable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import net.kazzz.felica.FeliCaException;
import net.kazzz.felica.command.PollingResponse;
import net.kazzz.felica.command.ReadResponse;
import net.kazzz.felica.command.WriteResponse;
import net.kazzz.felica.lib.FeliCaLib;
import net.kazzz.nfc.NfcTag;

public class FeliCaTag
extends NfcTag {
    public static final Parcelable.Creator<FeliCaTag> CREATOR = new Parcelable.Creator<FeliCaTag>(){

        public FeliCaTag createFromParcel(Parcel in) {
            return new FeliCaTag(in);
        }

        public FeliCaTag[] newArray(int size) {
            return new FeliCaTag[size];
        }
    };
    protected Tag nfcTag;
    protected FeliCaLib.IDm idm;
    protected FeliCaLib.PMm pmm;

    public FeliCaTag(Parcel in) {
        this.readFromParcel(in);
    }

    public FeliCaTag(Parcelable nfcTag) {
        this.nfcTag = (Tag)nfcTag;
    }

    public FeliCaTag(Tag nfcTag, FeliCaLib.IDm idm, FeliCaLib.PMm pmm) {
        this.nfcTag = nfcTag;
        this.idm = idm;
        this.pmm = pmm;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable((Parcelable)this.nfcTag, 0);
        dest.writeParcelable((Parcelable)this.idm, 0);
        dest.writeParcelable((Parcelable)this.pmm, 0);
    }

    @Override
    public void readFromParcel(Parcel source) {
        ClassLoader cl = this.getClass().getClassLoader();
        this.nfcTag = (Tag)source.readParcelable(cl);
        this.idm = (FeliCaLib.IDm)source.readParcelable(cl);
        this.pmm = (FeliCaLib.PMm)source.readParcelable(cl);
    }

    public byte[] polling(int systemCode) throws FeliCaException {
        if (this.nfcTag == null) {
            throw new FeliCaException("tagService is null. no polling execution");
        }
        FeliCaLib.CommandPacket polling = new FeliCaLib.CommandPacket(0, (byte)(systemCode >> 8), (byte)(systemCode & 0xFF), 1, 0);
        FeliCaLib.CommandResponse r = FeliCaLib.execute(this.nfcTag, polling);
        PollingResponse pr = new PollingResponse(r);
        this.idm = pr.getIDm();
        this.pmm = pr.getPMm();
        return pr.getBytes();
    }

    public FeliCaLib.IDm pollingAndGetIDm(int systemCode) throws FeliCaException {
        this.polling(systemCode);
        return this.idm;
    }

    public FeliCaLib.IDm getIDm() throws FeliCaException {
        return this.idm;
    }

    public FeliCaLib.PMm getPMm() throws FeliCaException {
        return this.pmm;
    }

    public final FeliCaLib.SystemCode[] getSystemCodeList() throws FeliCaException {
        FeliCaLib.CommandPacket reqSystemCode = new FeliCaLib.CommandPacket(12, this.idm, new byte[0]);
        FeliCaLib.CommandResponse r = FeliCaLib.execute(this.nfcTag, reqSystemCode);
        byte[] retBytes = r.getBytes();
        int num = retBytes[10];
        FeliCaLib.SystemCode[] retCodeList = new FeliCaLib.SystemCode[num];
        for (int i = 0; i < num; ++i) {
            retCodeList[i] = new FeliCaLib.SystemCode(Arrays.copyOfRange(retBytes, 11 + i * 2, 13 + i * 2));
        }
        return retCodeList;
    }

    public FeliCaLib.ServiceCode[] getServiceCodeList() throws FeliCaException {
        byte[] bytes;
        int index = 1;
        ArrayList<FeliCaLib.ServiceCode> serviceCodeList = new ArrayList<FeliCaLib.ServiceCode>();
        while ((bytes = this.doSearchServiceCode(index)).length == 2 || bytes.length == 4) {
            if (bytes.length == 2) {
                if (bytes[0] == -1 && bytes[1] == -1) break;
                serviceCodeList.add(new FeliCaLib.ServiceCode(bytes));
            }
            ++index;
        }
        return serviceCodeList.toArray(new FeliCaLib.ServiceCode[serviceCodeList.size()]);
    }

    protected byte[] doSearchServiceCode(int index) throws FeliCaException {
        FeliCaLib.CommandPacket reqServiceCode = new FeliCaLib.CommandPacket(10, this.idm, (byte)(index & 0xFF), (byte)(index >> 8));
        FeliCaLib.CommandResponse r = FeliCaLib.execute(this.nfcTag, reqServiceCode);
        byte[] bytes = r.getBytes();
        if (bytes == null || bytes.length <= 0 || bytes[1] != 11) {
            throw new FeliCaException("ResponseCode is not 0x0b");
        }
        return Arrays.copyOfRange(bytes, 10, bytes.length);
    }

    public ReadResponse readWithoutEncryption(FeliCaLib.ServiceCode serviceCode, byte addr) throws FeliCaException {
        if (this.nfcTag == null) {
            throw new FeliCaException("tagService is null. no read execution");
        }
        byte[] bytes = serviceCode.getBytes();
        FeliCaLib.CommandPacket readWoEncrypt = new FeliCaLib.CommandPacket(6, this.idm, 1, bytes[0], bytes[1], 1, -128, addr);
        FeliCaLib.CommandResponse r = FeliCaLib.execute(this.nfcTag, readWoEncrypt);
        return new ReadResponse(r);
    }

    public WriteResponse writeWithoutEncryption(FeliCaLib.ServiceCode serviceCode, byte addr, byte[] buff) throws FeliCaException {
        if (this.nfcTag == null) {
            throw new FeliCaException("tagService is null. no write execution");
        }
        byte[] bytes = serviceCode.getBytes();
        ByteBuffer b = ByteBuffer.allocate(22);
        b.put(new byte[]{1, bytes[0], bytes[1], 1, -128, addr});
        b.put(buff, 0, buff.length > 16 ? 16 : buff.length);
        FeliCaLib.CommandPacket writeWoEncrypt = new FeliCaLib.CommandPacket(8, this.idm, b.array());
        FeliCaLib.CommandResponse r = FeliCaLib.execute(this.nfcTag, writeWoEncrypt);
        return new WriteResponse(r);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("FeliCaTag \n");
        if (this.idm != null) {
            sb.append(this.idm.toString()).append("\n");
        }
        if (this.pmm != null) {
            sb.append(this.pmm.toString()).append("\n");
        }
        return sb.toString();
    }
}

