/*
 * Decompiled with CFR 0.152.
 */
package net.kazzz.felica;

import android.nfc.Tag;
import android.os.Parcel;
import android.os.Parcelable;
import java.nio.ByteBuffer;
import net.kazzz.felica.FeliCaException;
import net.kazzz.felica.command.PollingResponse;
import net.kazzz.felica.command.ReadResponse;
import net.kazzz.felica.command.WriteResponse;
import net.kazzz.felica.lib.FeliCaLib;
import net.kazzz.nfc.NfcTag;

public class FeliCaLiteTag
extends NfcTag {
    public static final Parcelable.Creator<FeliCaLiteTag> CREATOR = new Parcelable.Creator<FeliCaLiteTag>(){

        public FeliCaLiteTag createFromParcel(Parcel in) {
            return new FeliCaLiteTag(in);
        }

        public FeliCaLiteTag[] newArray(int size) {
            return new FeliCaLiteTag[size];
        }
    };
    protected Tag nfcTag;
    protected FeliCaLib.IDm idm;
    protected FeliCaLib.PMm pmm;

    public FeliCaLiteTag(Parcel in) {
        this.readFromParcel(in);
    }

    public FeliCaLiteTag(Parcelable nfcTag) {
        this.nfcTag = (Tag)nfcTag;
    }

    public FeliCaLiteTag(Tag nfcTag, FeliCaLib.IDm idm, FeliCaLib.PMm pmm) {
        this.nfcTag = nfcTag;
        this.idm = idm;
        this.pmm = pmm;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable((Parcelable)this.nfcTag, 0);
        dest.writeParcelable((Parcelable)this.idm, 0);
        dest.writeParcelable((Parcelable)this.pmm, 0);
    }

    @Override
    public void readFromParcel(Parcel source) {
        ClassLoader cl = this.getClass().getClassLoader();
        this.nfcTag = (Tag)source.readParcelable(cl);
        this.idm = (FeliCaLib.IDm)source.readParcelable(cl);
        this.pmm = (FeliCaLib.PMm)source.readParcelable(cl);
    }

    public byte[] polling() throws FeliCaException {
        if (this.nfcTag == null) {
            throw new FeliCaException("tagService is null. no polling execution");
        }
        FeliCaLib.CommandPacket polling = new FeliCaLib.CommandPacket(0, -120, -76, 1, 0);
        FeliCaLib.CommandResponse r = FeliCaLib.execute(this.nfcTag, polling);
        PollingResponse pr = new PollingResponse(r);
        this.idm = pr.getIDm();
        this.pmm = pr.getPMm();
        return pr.getBytes();
    }

    public FeliCaLib.IDm pollingAndGetIDm() throws FeliCaException {
        this.polling();
        return this.idm;
    }

    public FeliCaLib.IDm getIDm() throws FeliCaException {
        return this.idm;
    }

    public FeliCaLib.PMm getPMm() throws FeliCaException {
        return this.pmm;
    }

    public FeliCaLib.MemoryConfigurationBlock getMemoryConfigBlock() throws FeliCaException {
        ReadResponse r = this.readWithoutEncryption((byte)-120);
        return r != null ? new FeliCaLib.MemoryConfigurationBlock(r.getBlockData()) : null;
    }

    public ReadResponse readWithoutEncryption(byte addr) throws FeliCaException {
        if (this.nfcTag == null) {
            throw new FeliCaException("tagService is null. no read execution");
        }
        FeliCaLib.CommandPacket readWoEncrypt = new FeliCaLib.CommandPacket(6, this.idm, 1, 11, 0, 1, -128, addr);
        FeliCaLib.CommandResponse r = FeliCaLib.execute(this.nfcTag, readWoEncrypt);
        return new ReadResponse(r);
    }

    public WriteResponse writeWithoutEncryption(byte addr, byte[] buff) throws FeliCaException {
        if (this.nfcTag == null) {
            throw new FeliCaException("tagService is null. no write execution");
        }
        ByteBuffer b = ByteBuffer.allocate(22);
        b.put(new byte[]{1, 9, 0, 1, -128, addr});
        b.put(buff, 0, buff.length > 16 ? 16 : buff.length);
        FeliCaLib.CommandPacket writeWoEncrypt = new FeliCaLib.CommandPacket(8, this.idm, b.array());
        FeliCaLib.CommandResponse r = FeliCaLib.execute(this.nfcTag, writeWoEncrypt);
        return new WriteResponse(r);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("FeliCaLiteTag \n");
        if (this.idm != null) {
            sb.append(this.idm.toString()).append("\n");
        }
        if (this.pmm != null) {
            sb.append(this.pmm.toString()).append("\n");
        }
        return sb.toString();
    }
}

