// src/symbol.ts
import { wrap as comlink_wrap } from "comlink";
import {
  proxy,
  proxyMarker,
  finalizer,
  releaseProxy,
  createEndpoint
} from "comlink";
var endpointSymbol = Symbol("getEndpoint");
var wrap = (ep) => {
  const wrapped = comlink_wrap(ep);
  return new Proxy(wrapped, {
    get(target, prop, receiver) {
      if (prop === endpointSymbol) return ep;
      return Reflect.get(target, prop, receiver);
    }
  });
};
export {
  createEndpoint,
  endpointSymbol,
  finalizer,
  proxy,
  proxyMarker,
  releaseProxy,
  wrap
};
