'use client';
import { jsx } from 'react/jsx-runtime';
import { useId, useEffect } from 'react';
import { factory, useProps, ScrollArea } from '@mantine/core';
import { useSpotlightContext } from './Spotlight.context.mjs';
import { spotlightActions } from './spotlight.store.mjs';
import classes from './Spotlight.module.css.mjs';

const SpotlightActionsList = factory((props, ref) => {
  const { className, style, id, children, vars, classNames, styles, ...others } = useProps(
    "SpotlightActionsList",
    null,
    props
  );
  const ctx = useSpotlightContext();
  const generatedId = `mantine-${useId().replace(/:/g, "")}`;
  const listId = id || generatedId;
  useEffect(() => {
    spotlightActions.setListId(listId, ctx.store);
    return () => spotlightActions.setListId("", ctx.store);
  }, []);
  return /* @__PURE__ */ jsx(
    ScrollArea.Autosize,
    {
      ...ctx.getStyles("actionsList", { className, style, classNames, styles }),
      ref,
      type: "scroll",
      scrollbarSize: "var(--spotlight-actions-list-padding)",
      offsetScrollbars: "y",
      id: listId,
      ...others,
      children
    }
  );
});
SpotlightActionsList.classes = classes;
SpotlightActionsList.displayName = "@mantine/spotlight/SpotlightActionsList";

export { SpotlightActionsList };
//# sourceMappingURL=SpotlightActionsList.mjs.map
