'use client';
'use strict';

var jsxRuntime = require('react/jsx-runtime');
var react = require('react');
var core = require('@mantine/core');
var Spotlight_context = require('./Spotlight.context.cjs');
var spotlight_store = require('./spotlight.store.cjs');
var Spotlight_module = require('./Spotlight.module.css.cjs');

const SpotlightActionsList = core.factory((props, ref) => {
  const { className, style, id, children, vars, classNames, styles, ...others } = core.useProps(
    "SpotlightActionsList",
    null,
    props
  );
  const ctx = Spotlight_context.useSpotlightContext();
  const generatedId = `mantine-${react.useId().replace(/:/g, "")}`;
  const listId = id || generatedId;
  react.useEffect(() => {
    spotlight_store.spotlightActions.setListId(listId, ctx.store);
    return () => spotlight_store.spotlightActions.setListId("", ctx.store);
  }, []);
  return /* @__PURE__ */ jsxRuntime.jsx(
    core.ScrollArea.Autosize,
    {
      ...ctx.getStyles("actionsList", { className, style, classNames, styles }),
      ref,
      type: "scroll",
      scrollbarSize: "var(--spotlight-actions-list-padding)",
      offsetScrollbars: "y",
      id: listId,
      ...others,
      children
    }
  );
});
SpotlightActionsList.classes = Spotlight_module;
SpotlightActionsList.displayName = "@mantine/spotlight/SpotlightActionsList";

exports.SpotlightActionsList = SpotlightActionsList;
//# sourceMappingURL=SpotlightActionsList.cjs.map
