'use client';
'use strict';

var jsxRuntime = require('react/jsx-runtime');
var core = require('@mantine/core');
var Spotlight_context = require('./Spotlight.context.cjs');
var spotlight_store = require('./spotlight.store.cjs');
var Spotlight_module = require('./Spotlight.module.css.cjs');

const defaultProps = {
  dimmedSections: true,
  highlightQuery: false
};
const SpotlightAction = core.factory((_props, ref) => {
  const props = core.useProps("SpotlightAction", defaultProps, _props);
  const {
    className,
    style,
    classNames,
    styles,
    id,
    description,
    label,
    leftSection,
    rightSection,
    children,
    dimmedSections,
    highlightQuery,
    highlightColor,
    closeSpotlightOnTrigger,
    onClick,
    onMouseDown,
    keywords,
    vars,
    ...others
  } = props;
  const ctx = Spotlight_context.useSpotlightContext();
  const stylesApi = { classNames, styles };
  const labelNode = highlightQuery && typeof label === "string" ? /* @__PURE__ */ jsxRuntime.jsx(
    core.Highlight,
    {
      component: "span",
      highlight: ctx.query,
      color: highlightColor,
      ...ctx.getStyles("actionLabel", stylesApi),
      children: label
    }
  ) : /* @__PURE__ */ jsxRuntime.jsx("span", { ...ctx.getStyles("actionLabel", stylesApi), children: label });
  return /* @__PURE__ */ jsxRuntime.jsx(
    core.UnstyledButton,
    {
      ref,
      "data-action": true,
      ...ctx.getStyles("action", { className, style, ...stylesApi }),
      ...others,
      onMouseDown: (event) => {
        event.preventDefault();
        onMouseDown?.(event);
      },
      onClick: (event) => {
        onClick?.(event);
        if (closeSpotlightOnTrigger ?? ctx.closeOnActionTrigger) {
          spotlight_store.spotlightActions.close(ctx.store);
        }
      },
      tabIndex: -1,
      children: children || /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
        leftSection && /* @__PURE__ */ jsxRuntime.jsx(
          core.Box,
          {
            component: "span",
            mod: { position: "left", dimmed: dimmedSections },
            ...ctx.getStyles("actionSection", stylesApi),
            children: leftSection
          }
        ),
        /* @__PURE__ */ jsxRuntime.jsxs("span", { ...ctx.getStyles("actionBody", stylesApi), children: [
          labelNode,
          /* @__PURE__ */ jsxRuntime.jsx("span", { ...ctx.getStyles("actionDescription", stylesApi), children: description })
        ] }),
        rightSection && /* @__PURE__ */ jsxRuntime.jsx(
          core.Box,
          {
            component: "span",
            mod: { position: "right", dimmed: dimmedSections },
            ...ctx.getStyles("actionSection", stylesApi),
            children: rightSection
          }
        )
      ] })
    }
  );
});
SpotlightAction.classes = Spotlight_module;
SpotlightAction.displayName = "@mantine/spotlight/SpotlightAction";

exports.SpotlightAction = SpotlightAction;
//# sourceMappingURL=SpotlightAction.cjs.map
