'use client';
'use strict';

var jsxRuntime = require('react/jsx-runtime');
var core = require('@mantine/core');
var hooks = require('@mantine/hooks');
var defaultSpotlightFilter = require('./default-spotlight-filter.cjs');
var isActionsGroup = require('./is-actions-group.cjs');
var limitActions = require('./limit-actions.cjs');
var spotlight_store = require('./spotlight.store.cjs');
var SpotlightAction = require('./SpotlightAction.cjs');
var SpotlightActionsGroup = require('./SpotlightActionsGroup.cjs');
var SpotlightActionsList = require('./SpotlightActionsList.cjs');
var SpotlightEmpty = require('./SpotlightEmpty.cjs');
var SpotlightFooter = require('./SpotlightFooter.cjs');
var SpotlightRoot = require('./SpotlightRoot.cjs');
var SpotlightSearch = require('./SpotlightSearch.cjs');
var Spotlight_module = require('./Spotlight.module.css.cjs');

const defaultProps = {
  size: 600,
  yOffset: 80,
  limit: Infinity,
  zIndex: core.getDefaultZIndex("max"),
  overlayProps: { backgroundOpacity: 0.35, blur: 7 },
  transitionProps: { duration: 200, transition: "pop" },
  store: spotlight_store.spotlightStore,
  filter: defaultSpotlightFilter.defaultSpotlightFilter,
  clearQueryOnClose: true,
  closeOnActionTrigger: true,
  shortcut: "mod + K"
};
const Spotlight = core.factory((_props, ref) => {
  const props = core.useProps("Spotlight", defaultProps, _props);
  const {
    searchProps,
    filter,
    query,
    onQueryChange,
    actions,
    nothingFound,
    highlightQuery,
    limit,
    scrollAreaProps,
    ...others
  } = props;
  const [_query, setQuery] = hooks.useUncontrolled({
    value: query,
    defaultValue: "",
    finalValue: "",
    onChange: onQueryChange
  });
  const filteredActions = limitActions.limitActions(filter(_query, actions), limit).map((item) => {
    if (isActionsGroup.isActionsGroup(item)) {
      const items = item.actions.map(({ id, ...actionData }) => /* @__PURE__ */ jsxRuntime.jsx(SpotlightAction.SpotlightAction, { highlightQuery, ...actionData }, id));
      return /* @__PURE__ */ jsxRuntime.jsx(SpotlightActionsGroup.SpotlightActionsGroup, { label: item.group, children: items }, item.group);
    }
    return /* @__PURE__ */ jsxRuntime.jsx(SpotlightAction.SpotlightAction, { highlightQuery, ...item }, item.id);
  });
  return /* @__PURE__ */ jsxRuntime.jsxs(SpotlightRoot.SpotlightRoot, { ...others, query: _query, onQueryChange: setQuery, ref, children: [
    /* @__PURE__ */ jsxRuntime.jsx(SpotlightSearch.SpotlightSearch, { ...searchProps }),
    /* @__PURE__ */ jsxRuntime.jsxs(SpotlightActionsList.SpotlightActionsList, { ...scrollAreaProps, children: [
      filteredActions,
      filteredActions.length === 0 && nothingFound && /* @__PURE__ */ jsxRuntime.jsx(SpotlightEmpty.SpotlightEmpty, { children: nothingFound })
    ] })
  ] });
});
Spotlight.classes = Spotlight_module;
Spotlight.displayName = "@mantine/spotlight/Spotlight";
Spotlight.Search = SpotlightSearch.SpotlightSearch;
Spotlight.ActionsList = SpotlightActionsList.SpotlightActionsList;
Spotlight.Action = SpotlightAction.SpotlightAction;
Spotlight.Empty = SpotlightEmpty.SpotlightEmpty;
Spotlight.ActionsGroup = SpotlightActionsGroup.SpotlightActionsGroup;
Spotlight.Footer = SpotlightFooter.SpotlightFooter;
Spotlight.Root = SpotlightRoot.SpotlightRoot;
Spotlight.open = spotlight_store.spotlight.open;
Spotlight.close = spotlight_store.spotlight.close;
Spotlight.toggle = spotlight_store.spotlight.toggle;

exports.Spotlight = Spotlight;
//# sourceMappingURL=Spotlight.cjs.map
