import { BasePortalProps, BoxProps, ElementProps, Factory, StylesApiProps } from '@mantine/core';
import { DropzoneProps, DropzoneStylesNames, DropzoneVariant } from './Dropzone';
export type DropzoneFullScreenStylesNames = DropzoneStylesNames | 'fullScreen';
export interface DropzoneFullScreenProps extends BoxProps, Omit<DropzoneProps, 'styles' | 'classNames' | 'vars' | 'variant' | 'attributes'>, StylesApiProps<DropzoneFullScreenFactory>, ElementProps<'div', 'onDragLeave' | 'onDragOver' | 'onDrop' | 'onDragEnter'> {
    /** Determines whether user can drop files to browser window @default `true` */
    active?: boolean;
    /** Z-index value @default `9999` */
    zIndex?: React.CSSProperties['zIndex'];
    /** Determines whether component should be rendered within `Portal` @default `true` */
    withinPortal?: boolean;
    /** Props to pass down to the portal when withinPortal is `true` */
    portalProps?: Omit<BasePortalProps, 'withinPortal'>;
}
export type DropzoneFullScreenFactory = Factory<{
    props: DropzoneFullScreenProps;
    ref: HTMLDivElement;
    stylesNames: DropzoneFullScreenStylesNames;
    variant: DropzoneVariant;
}>;
export declare const DropzoneFullScreen: import("@mantine/core").MantineComponent<{
    props: DropzoneFullScreenProps;
    ref: HTMLDivElement;
    stylesNames: DropzoneFullScreenStylesNames;
    variant: DropzoneVariant;
}>;
export type DropzoneFullScreenType = typeof DropzoneFullScreen;
