'use client';
import { jsx, jsxs } from 'react/jsx-runtime';
import { useDropzone } from 'react-dropzone';
import { createVarsResolver, getRadius, factory, useProps, useStyles, Box, LoadingOverlay } from '@mantine/core';
import { assignRef } from '@mantine/hooks';
import { DropzoneProvider } from './Dropzone.context.mjs';
import { DropzoneAccept, DropzoneIdle, DropzoneReject } from './DropzoneStatus.mjs';
import classes from './Dropzone.module.css.mjs';

const defaultProps = {
  multiple: true,
  maxSize: Infinity,
  activateOnClick: true,
  activateOnDrag: true,
  dragEventsBubbling: true,
  activateOnKeyboard: true,
  useFsAccessApi: true,
  variant: "light",
  rejectColor: "red"
};
const varsResolver = createVarsResolver(
  (theme, { radius, variant, acceptColor, rejectColor }) => {
    const acceptColors = theme.variantColorResolver({
      color: acceptColor || theme.primaryColor,
      theme,
      variant
    });
    const rejectColors = theme.variantColorResolver({
      color: rejectColor || "red",
      theme,
      variant
    });
    return {
      root: {
        "--dropzone-radius": getRadius(radius),
        "--dropzone-accept-color": acceptColors.color,
        "--dropzone-accept-bg": acceptColors.background,
        "--dropzone-reject-color": rejectColors.color,
        "--dropzone-reject-bg": rejectColors.background
      }
    };
  }
);
const Dropzone = factory((_props, ref) => {
  const props = useProps("Dropzone", defaultProps, _props);
  const {
    classNames,
    className,
    style,
    styles,
    unstyled,
    vars,
    radius,
    disabled,
    loading,
    multiple,
    maxSize,
    accept,
    children,
    onDropAny,
    onDrop,
    onReject,
    openRef,
    name,
    maxFiles,
    autoFocus,
    activateOnClick,
    activateOnDrag,
    dragEventsBubbling,
    activateOnKeyboard,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onFileDialogCancel,
    onFileDialogOpen,
    preventDropOnDocument,
    useFsAccessApi,
    getFilesFromEvent,
    validator,
    rejectColor,
    acceptColor,
    enablePointerEvents,
    loaderProps,
    inputProps,
    mod,
    attributes,
    ...others
  } = props;
  const getStyles = useStyles({
    name: "Dropzone",
    classes,
    props,
    className,
    style,
    classNames,
    styles,
    unstyled,
    attributes,
    vars,
    varsResolver
  });
  const { getRootProps, getInputProps, isDragAccept, isDragReject, isDragActive, open } = useDropzone({
    onDrop: onDropAny,
    onDropAccepted: onDrop,
    onDropRejected: onReject,
    disabled: disabled || loading,
    accept: Array.isArray(accept) ? accept.reduce((r, key) => ({ ...r, [key]: [] }), {}) : accept,
    multiple,
    maxSize,
    maxFiles,
    autoFocus,
    noClick: !activateOnClick,
    noDrag: !activateOnDrag,
    noDragEventsBubbling: !dragEventsBubbling,
    noKeyboard: !activateOnKeyboard,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onFileDialogCancel,
    onFileDialogOpen,
    preventDropOnDocument,
    useFsAccessApi,
    validator,
    ...getFilesFromEvent ? { getFilesFromEvent } : null
  });
  assignRef(openRef, open);
  const isAccepted = isDragActive && isDragAccept;
  const isRejected = isDragActive && isDragReject;
  const isIdle = !isAccepted && !isRejected;
  return /* @__PURE__ */ jsx(DropzoneProvider, { value: { accept: isAccepted, reject: isRejected, idle: isIdle }, children: /* @__PURE__ */ jsxs(
    Box,
    {
      ...getRootProps(),
      ...getStyles("root", { focusable: true }),
      ...others,
      mod: [
        {
          accept: isAccepted,
          reject: isRejected,
          idle: isIdle,
          disabled,
          loading,
          "activate-on-click": activateOnClick
        },
        mod
      ],
      children: [
        /* @__PURE__ */ jsx(
          LoadingOverlay,
          {
            visible: loading,
            overlayProps: { radius },
            unstyled,
            loaderProps
          }
        ),
        /* @__PURE__ */ jsx("input", { ...getInputProps(inputProps), name }),
        /* @__PURE__ */ jsx(
          "div",
          {
            ...getStyles("inner"),
            ref,
            "data-enable-pointer-events": enablePointerEvents || void 0,
            children
          }
        )
      ]
    }
  ) });
});
Dropzone.classes = classes;
Dropzone.displayName = "@mantine/dropzone/Dropzone";
Dropzone.Accept = DropzoneAccept;
Dropzone.Idle = DropzoneIdle;
Dropzone.Reject = DropzoneReject;

export { Dropzone };
//# sourceMappingURL=Dropzone.mjs.map
