'use client';
import { jsx } from 'react/jsx-runtime';
import { keys } from '../../../core/utils/keys/keys.mjs';
import '../../../core/utils/units-converters/rem.mjs';
import { filterProps } from '../../../core/utils/filter-props/filter-props.mjs';
import 'react';
import { getSortedBreakpoints } from '../../../core/utils/get-sorted-breakpoints/get-sorted-breakpoints.mjs';
import { getBaseValue } from '../../../core/utils/get-base-value/get-base-value.mjs';
import '@mantine/hooks';
import 'clsx';
import '../../../core/MantineProvider/Mantine.context.mjs';
import '../../../core/MantineProvider/default-theme.mjs';
import '../../../core/MantineProvider/MantineProvider.mjs';
import { useMantineTheme } from '../../../core/MantineProvider/MantineThemeProvider/MantineThemeProvider.mjs';
import '../../../core/MantineProvider/MantineCssVariables/MantineCssVariables.mjs';
import { InlineStyles } from '../../../core/InlineStyles/InlineStyles.mjs';
import '../../../core/Box/Box.mjs';
import '../../../core/DirectionProvider/DirectionProvider.mjs';
import { useGridContext } from '../Grid.context.mjs';

const getColumnFlexBasis = (colSpan, columns) => {
  if (colSpan === "content") {
    return "auto";
  }
  if (colSpan === "auto") {
    return "0rem";
  }
  return colSpan ? `${100 / (columns / colSpan)}%` : void 0;
};
const getColumnMaxWidth = (colSpan, columns, grow) => {
  if (grow || colSpan === "auto") {
    return "100%";
  }
  if (colSpan === "content") {
    return "unset";
  }
  return getColumnFlexBasis(colSpan, columns);
};
const getColumnFlexGrow = (colSpan, grow) => {
  if (!colSpan) {
    return void 0;
  }
  return colSpan === "auto" || grow ? "1" : "auto";
};
const getColumnOffset = (offset, columns) => offset === 0 ? "0" : offset ? `${100 / (columns / offset)}%` : void 0;
function GridColVariables({ span, order, offset, selector }) {
  const theme = useMantineTheme();
  const ctx = useGridContext();
  const _breakpoints = ctx.breakpoints || theme.breakpoints;
  const baseValue = getBaseValue(span);
  const baseSpan = baseValue === void 0 ? 12 : getBaseValue(span);
  const baseStyles = filterProps({
    "--col-order": getBaseValue(order)?.toString(),
    "--col-flex-grow": getColumnFlexGrow(baseSpan, ctx.grow),
    "--col-flex-basis": getColumnFlexBasis(baseSpan, ctx.columns),
    "--col-width": baseSpan === "content" ? "auto" : void 0,
    "--col-max-width": getColumnMaxWidth(baseSpan, ctx.columns, ctx.grow),
    "--col-offset": getColumnOffset(getBaseValue(offset), ctx.columns)
  });
  const queries = keys(_breakpoints).reduce(
    (acc, breakpoint) => {
      if (!acc[breakpoint]) {
        acc[breakpoint] = {};
      }
      if (typeof order === "object" && order[breakpoint] !== void 0) {
        acc[breakpoint]["--col-order"] = order[breakpoint]?.toString();
      }
      if (typeof span === "object" && span[breakpoint] !== void 0) {
        acc[breakpoint]["--col-flex-grow"] = getColumnFlexGrow(span[breakpoint], ctx.grow);
        acc[breakpoint]["--col-flex-basis"] = getColumnFlexBasis(span[breakpoint], ctx.columns);
        acc[breakpoint]["--col-width"] = span[breakpoint] === "content" ? "auto" : void 0;
        acc[breakpoint]["--col-max-width"] = getColumnMaxWidth(
          span[breakpoint],
          ctx.columns,
          ctx.grow
        );
      }
      if (typeof offset === "object" && offset[breakpoint] !== void 0) {
        acc[breakpoint]["--col-offset"] = getColumnOffset(offset[breakpoint], ctx.columns);
      }
      return acc;
    },
    {}
  );
  const sortedBreakpoints = getSortedBreakpoints(keys(queries), _breakpoints).filter(
    (breakpoint) => keys(queries[breakpoint.value]).length > 0
  );
  const values = sortedBreakpoints.map((breakpoint) => ({
    query: ctx.type === "container" ? `mantine-grid (min-width: ${_breakpoints[breakpoint.value]})` : `(min-width: ${_breakpoints[breakpoint.value]})`,
    styles: queries[breakpoint.value]
  }));
  return /* @__PURE__ */ jsx(
    InlineStyles,
    {
      styles: baseStyles,
      media: ctx.type === "container" ? void 0 : values,
      container: ctx.type === "container" ? values : void 0,
      selector
    }
  );
}

export { GridColVariables };
//# sourceMappingURL=GridColVariables.mjs.map
