import {Button, FileInput, Group, Modal} from '@mantine/core'
import {useSelector} from '../state/store'
import {closeImportDialog, importFileChanged, importNotes} from '../state/import'
import {useCloseOnBack} from '../helpers/useCloseOnBack'

export const ImportNotesDialog = () => {
  const {open, file, error} = useSelector((state) => state.import.importDialog)
  useCloseOnBack({
    id: 'import-notes-dialog',
    open,
    onClose: closeImportDialog,
  })
  return (
    <Modal opened={open} onClose={closeImportDialog} title='Import notes'>
      <FileInput
        value={file}
        onChange={importFileChanged}
        label='Select backup .zip'
        accept='.zip,application/zip,application/x-zip-compressed'
        error={error}
      />
      <Group justify='end' mt='lg'>
        <Button onClick={importNotes} disabled={!file}>
          Import
        </Button>
      </Group>
    </Modal>
  )
}
