'use client';
function getKeywords(keywords) {
  if (Array.isArray(keywords)) {
    return keywords.map((keyword) => keyword.trim()).join(",").toLowerCase().trim();
  }
  if (typeof keywords === "string") {
    return keywords.toLowerCase().trim();
  }
  return "";
}
function getFlatActions(data) {
  return data.reduce((acc, item) => {
    if ("actions" in item) {
      return [...acc, ...item.actions.map((action) => ({ ...action, group: item.group }))];
    }
    return [...acc, item];
  }, []);
}
function flatActionsToGroups(data) {
  const groups = {};
  const result = [];
  data.forEach((action) => {
    if (action.group) {
      if (!groups[action.group]) {
        groups[action.group] = { pushed: false, data: { group: action.group, actions: [] } };
      }
      groups[action.group].data.actions.push(action);
      if (!groups[action.group].pushed) {
        groups[action.group].pushed = true;
        result.push(groups[action.group].data);
      }
    } else {
      result.push(action);
    }
  });
  return result;
}
const defaultSpotlightFilter = (_query, data) => {
  const query = _query.trim().toLowerCase();
  const priorityMatrix = [[], []];
  const flatActions = getFlatActions(data);
  flatActions.forEach((item) => {
    if (item.label?.toLowerCase().includes(query)) {
      priorityMatrix[0].push(item);
    } else if (item.description?.toLowerCase().includes(query) || getKeywords(item.keywords).includes(query)) {
      priorityMatrix[1].push(item);
    }
  });
  return flatActionsToGroups(priorityMatrix.flat());
};

export { defaultSpotlightFilter };
//# sourceMappingURL=default-spotlight-filter.mjs.map
