'use client';
import { jsx } from 'react/jsx-runtime';
import { useState } from 'react';
import { factory, useProps, Input } from '@mantine/core';
import { useSpotlightContext } from './Spotlight.context.mjs';
import { spotlightActions } from './spotlight.store.mjs';
import classes from './Spotlight.module.css.mjs';

const defaultProps = {
  size: "lg"
};
const SpotlightSearch = factory((props, ref) => {
  const { classNames, styles, onKeyDown, onChange, vars, value, ...others } = useProps(
    "SpotlightSearch",
    defaultProps,
    props
  );
  const ctx = useSpotlightContext();
  const inputStyles = ctx.getStyles("search");
  const [isComposing, setIsComposing] = useState(false);
  const handleKeyDown = (event) => {
    onKeyDown?.(event);
    if (isComposing) {
      return;
    }
    if (event.nativeEvent.code === "ArrowDown") {
      event.preventDefault();
      spotlightActions.selectNextAction(ctx.store);
    }
    if (event.nativeEvent.code === "ArrowUp") {
      event.preventDefault();
      spotlightActions.selectPreviousAction(ctx.store);
    }
    if (event.nativeEvent.code === "Enter" || event.nativeEvent.code === "NumpadEnter") {
      event.preventDefault();
      spotlightActions.triggerSelectedAction(ctx.store);
    }
  };
  return /* @__PURE__ */ jsx(
    Input,
    {
      ref,
      classNames: [{ input: inputStyles.className }, classNames],
      styles: [{ input: inputStyles.style }, styles],
      ...others,
      value: value ?? ctx.query,
      onChange: (event) => {
        ctx.setQuery(event.currentTarget.value);
        onChange?.(event);
      },
      onKeyDown: handleKeyDown,
      onCompositionStart: () => setIsComposing(true),
      onCompositionEnd: () => setIsComposing(false)
    }
  );
});
SpotlightSearch.classes = classes;
SpotlightSearch.displayName = "@mantine/spotlight/SpotlightSearch";

export { SpotlightSearch };
//# sourceMappingURL=SpotlightSearch.mjs.map
