'use client';
import { jsx, jsxs, Fragment } from 'react/jsx-runtime';
import { factory, useProps, Highlight, UnstyledButton, Box } from '@mantine/core';
import { useSpotlightContext } from './Spotlight.context.mjs';
import { spotlightActions } from './spotlight.store.mjs';
import classes from './Spotlight.module.css.mjs';

const defaultProps = {
  dimmedSections: true,
  highlightQuery: false
};
const SpotlightAction = factory((_props, ref) => {
  const props = useProps("SpotlightAction", defaultProps, _props);
  const {
    className,
    style,
    classNames,
    styles,
    id,
    description,
    label,
    leftSection,
    rightSection,
    children,
    dimmedSections,
    highlightQuery,
    highlightColor,
    closeSpotlightOnTrigger,
    onClick,
    onMouseDown,
    keywords,
    vars,
    ...others
  } = props;
  const ctx = useSpotlightContext();
  const stylesApi = { classNames, styles };
  const labelNode = highlightQuery && typeof label === "string" ? /* @__PURE__ */ jsx(
    Highlight,
    {
      component: "span",
      highlight: ctx.query,
      color: highlightColor,
      ...ctx.getStyles("actionLabel", stylesApi),
      children: label
    }
  ) : /* @__PURE__ */ jsx("span", { ...ctx.getStyles("actionLabel", stylesApi), children: label });
  return /* @__PURE__ */ jsx(
    UnstyledButton,
    {
      ref,
      "data-action": true,
      ...ctx.getStyles("action", { className, style, ...stylesApi }),
      ...others,
      onMouseDown: (event) => {
        event.preventDefault();
        onMouseDown?.(event);
      },
      onClick: (event) => {
        onClick?.(event);
        if (closeSpotlightOnTrigger ?? ctx.closeOnActionTrigger) {
          spotlightActions.close(ctx.store);
        }
      },
      tabIndex: -1,
      children: children || /* @__PURE__ */ jsxs(Fragment, { children: [
        leftSection && /* @__PURE__ */ jsx(
          Box,
          {
            component: "span",
            mod: { position: "left", dimmed: dimmedSections },
            ...ctx.getStyles("actionSection", stylesApi),
            children: leftSection
          }
        ),
        /* @__PURE__ */ jsxs("span", { ...ctx.getStyles("actionBody", stylesApi), children: [
          labelNode,
          /* @__PURE__ */ jsx("span", { ...ctx.getStyles("actionDescription", stylesApi), children: description })
        ] }),
        rightSection && /* @__PURE__ */ jsx(
          Box,
          {
            component: "span",
            mod: { position: "right", dimmed: dimmedSections },
            ...ctx.getStyles("actionSection", stylesApi),
            children: rightSection
          }
        )
      ] })
    }
  );
});
SpotlightAction.classes = classes;
SpotlightAction.displayName = "@mantine/spotlight/SpotlightAction";

export { SpotlightAction };
//# sourceMappingURL=SpotlightAction.mjs.map
