'use client';
'use strict';

var jsxRuntime = require('react/jsx-runtime');
var react = require('react');
var core = require('@mantine/core');
var Spotlight_context = require('./Spotlight.context.cjs');
var spotlight_store = require('./spotlight.store.cjs');
var Spotlight_module = require('./Spotlight.module.css.cjs');

const defaultProps = {
  size: "lg"
};
const SpotlightSearch = core.factory((props, ref) => {
  const { classNames, styles, onKeyDown, onChange, vars, value, ...others } = core.useProps(
    "SpotlightSearch",
    defaultProps,
    props
  );
  const ctx = Spotlight_context.useSpotlightContext();
  const inputStyles = ctx.getStyles("search");
  const [isComposing, setIsComposing] = react.useState(false);
  const handleKeyDown = (event) => {
    onKeyDown?.(event);
    if (isComposing) {
      return;
    }
    if (event.nativeEvent.code === "ArrowDown") {
      event.preventDefault();
      spotlight_store.spotlightActions.selectNextAction(ctx.store);
    }
    if (event.nativeEvent.code === "ArrowUp") {
      event.preventDefault();
      spotlight_store.spotlightActions.selectPreviousAction(ctx.store);
    }
    if (event.nativeEvent.code === "Enter" || event.nativeEvent.code === "NumpadEnter") {
      event.preventDefault();
      spotlight_store.spotlightActions.triggerSelectedAction(ctx.store);
    }
  };
  return /* @__PURE__ */ jsxRuntime.jsx(
    core.Input,
    {
      ref,
      classNames: [{ input: inputStyles.className }, classNames],
      styles: [{ input: inputStyles.style }, styles],
      ...others,
      value: value ?? ctx.query,
      onChange: (event) => {
        ctx.setQuery(event.currentTarget.value);
        onChange?.(event);
      },
      onKeyDown: handleKeyDown,
      onCompositionStart: () => setIsComposing(true),
      onCompositionEnd: () => setIsComposing(false)
    }
  );
});
SpotlightSearch.classes = Spotlight_module;
SpotlightSearch.displayName = "@mantine/spotlight/SpotlightSearch";

exports.SpotlightSearch = SpotlightSearch;
//# sourceMappingURL=SpotlightSearch.cjs.map
