'use client';
import { jsx } from 'react/jsx-runtime';
import { useState, useEffect } from 'react';
import { getDefaultZIndex, factory, useProps, useStyles, useResolvedStylesApi, OptionalPortal, Box } from '@mantine/core';
import { useDisclosure } from '@mantine/hooks';
import { Dropzone } from './Dropzone.mjs';
import classes from './Dropzone.module.css.mjs';

const defaultProps = {
  maxSize: Infinity,
  activateOnDrag: true,
  dragEventsBubbling: true,
  activateOnKeyboard: true,
  active: true,
  zIndex: getDefaultZIndex("max"),
  withinPortal: true
};
const DropzoneFullScreen = factory((_props, ref) => {
  const props = useProps("DropzoneFullScreen", defaultProps, _props);
  const {
    classNames,
    className,
    style,
    styles,
    unstyled,
    vars,
    active,
    onDrop,
    onReject,
    zIndex,
    withinPortal,
    portalProps,
    attributes,
    ...others
  } = props;
  const getStyles = useStyles({
    name: "DropzoneFullScreen",
    classes,
    props,
    className,
    style,
    classNames,
    styles,
    unstyled,
    attributes,
    rootSelector: "fullScreen"
  });
  const { resolvedClassNames, resolvedStyles } = useResolvedStylesApi({
    classNames,
    styles,
    props
  });
  const [counter, setCounter] = useState(0);
  const [visible, { open, close }] = useDisclosure(false);
  const handleDragEnter = (event) => {
    if (event.dataTransfer?.types.includes("Files")) {
      setCounter((prev) => prev + 1);
      open();
    }
  };
  const handleDragLeave = () => {
    setCounter((prev) => prev - 1);
  };
  useEffect(() => {
    counter === 0 && close();
  }, [counter]);
  useEffect(() => {
    if (!active) {
      return void 0;
    }
    document.addEventListener("dragenter", handleDragEnter, false);
    document.addEventListener("dragleave", handleDragLeave, false);
    return () => {
      document.removeEventListener("dragenter", handleDragEnter, false);
      document.removeEventListener("dragleave", handleDragLeave, false);
    };
  }, [active]);
  return /* @__PURE__ */ jsx(OptionalPortal, { ...portalProps, withinPortal, children: /* @__PURE__ */ jsx(
    Box,
    {
      ref,
      ...getStyles("fullScreen", {
        style: { opacity: visible ? 1 : 0, pointerEvents: visible ? "all" : "none", zIndex }
      }),
      children: /* @__PURE__ */ jsx(
        Dropzone,
        {
          activateOnClick: false,
          ...others,
          classNames: resolvedClassNames,
          styles: resolvedStyles,
          unstyled,
          className: classes.dropzone,
          onDrop: (files) => {
            onDrop?.(files);
            close();
            setCounter(0);
          },
          onReject: (files) => {
            onReject?.(files);
            close();
            setCounter(0);
          }
        }
      )
    }
  ) });
});
DropzoneFullScreen.classes = classes;
DropzoneFullScreen.displayName = "@mantine/dropzone/DropzoneFullScreen";

export { DropzoneFullScreen };
//# sourceMappingURL=DropzoneFullScreen.mjs.map
