'use client';
'use strict';

var jsxRuntime = require('react/jsx-runtime');
var react = require('react');
var core = require('@mantine/core');
var hooks = require('@mantine/hooks');
var Dropzone_context = require('./Dropzone.context.cjs');

function createDropzoneStatus(status) {
  const Component = (props) => {
    const { children, ...others } = core.useProps(`Dropzone${hooks.upperFirst(status)}`, {}, props);
    const ctx = Dropzone_context.useDropzoneContext();
    const _children = core.isElement(children) ? children : /* @__PURE__ */ jsxRuntime.jsx("span", { children });
    if (ctx[status]) {
      return react.cloneElement(_children, others);
    }
    return null;
  };
  Component.displayName = `@mantine/dropzone/${hooks.upperFirst(status)}`;
  return Component;
}
const DropzoneAccept = createDropzoneStatus("accept");
const DropzoneReject = createDropzoneStatus("reject");
const DropzoneIdle = createDropzoneStatus("idle");

exports.DropzoneAccept = DropzoneAccept;
exports.DropzoneIdle = DropzoneIdle;
exports.DropzoneReject = DropzoneReject;
//# sourceMappingURL=DropzoneStatus.cjs.map
