'use client';
'use strict';

var jsxRuntime = require('react/jsx-runtime');
var react = require('react');
var core = require('@mantine/core');
var hooks = require('@mantine/hooks');
var Dropzone = require('./Dropzone.cjs');
var Dropzone_module = require('./Dropzone.module.css.cjs');

const defaultProps = {
  maxSize: Infinity,
  activateOnDrag: true,
  dragEventsBubbling: true,
  activateOnKeyboard: true,
  active: true,
  zIndex: core.getDefaultZIndex("max"),
  withinPortal: true
};
const DropzoneFullScreen = core.factory((_props, ref) => {
  const props = core.useProps("DropzoneFullScreen", defaultProps, _props);
  const {
    classNames,
    className,
    style,
    styles,
    unstyled,
    vars,
    active,
    onDrop,
    onReject,
    zIndex,
    withinPortal,
    portalProps,
    attributes,
    ...others
  } = props;
  const getStyles = core.useStyles({
    name: "DropzoneFullScreen",
    classes: Dropzone_module,
    props,
    className,
    style,
    classNames,
    styles,
    unstyled,
    attributes,
    rootSelector: "fullScreen"
  });
  const { resolvedClassNames, resolvedStyles } = core.useResolvedStylesApi({
    classNames,
    styles,
    props
  });
  const [counter, setCounter] = react.useState(0);
  const [visible, { open, close }] = hooks.useDisclosure(false);
  const handleDragEnter = (event) => {
    if (event.dataTransfer?.types.includes("Files")) {
      setCounter((prev) => prev + 1);
      open();
    }
  };
  const handleDragLeave = () => {
    setCounter((prev) => prev - 1);
  };
  react.useEffect(() => {
    counter === 0 && close();
  }, [counter]);
  react.useEffect(() => {
    if (!active) {
      return void 0;
    }
    document.addEventListener("dragenter", handleDragEnter, false);
    document.addEventListener("dragleave", handleDragLeave, false);
    return () => {
      document.removeEventListener("dragenter", handleDragEnter, false);
      document.removeEventListener("dragleave", handleDragLeave, false);
    };
  }, [active]);
  return /* @__PURE__ */ jsxRuntime.jsx(core.OptionalPortal, { ...portalProps, withinPortal, children: /* @__PURE__ */ jsxRuntime.jsx(
    core.Box,
    {
      ref,
      ...getStyles("fullScreen", {
        style: { opacity: visible ? 1 : 0, pointerEvents: visible ? "all" : "none", zIndex }
      }),
      children: /* @__PURE__ */ jsxRuntime.jsx(
        Dropzone.Dropzone,
        {
          activateOnClick: false,
          ...others,
          classNames: resolvedClassNames,
          styles: resolvedStyles,
          unstyled,
          className: Dropzone_module.dropzone,
          onDrop: (files) => {
            onDrop?.(files);
            close();
            setCounter(0);
          },
          onReject: (files) => {
            onReject?.(files);
            close();
            setCounter(0);
          }
        }
      )
    }
  ) });
});
DropzoneFullScreen.classes = Dropzone_module;
DropzoneFullScreen.displayName = "@mantine/dropzone/DropzoneFullScreen";

exports.DropzoneFullScreen = DropzoneFullScreen;
//# sourceMappingURL=DropzoneFullScreen.cjs.map
