import { BoxProps, ElementProps, Factory, MantineColor, MantineRadius, StylesApiProps } from '../../core';
import { TabsList, TabsListStylesNames } from './TabsList/TabsList';
import { TabsPanel, TabsPanelStylesNames } from './TabsPanel/TabsPanel';
import { TabsTab, TabsTabStylesNames } from './TabsTab/TabsTab';
export type TabsStylesNames = 'root' | TabsListStylesNames | TabsPanelStylesNames | TabsTabStylesNames;
export type TabsVariant = 'default' | 'outline' | 'pills';
export type TabsCssVariables = {
    root: '--tabs-color' | '--tabs-radius';
};
export interface TabsProps extends BoxProps, StylesApiProps<TabsFactory>, ElementProps<'div', 'defaultValue' | 'value' | 'onChange'> {
    /** Uncontrolled component default value */
    defaultValue?: string | null;
    /** Controlled component value */
    value?: string | null;
    /** Called when value changes */
    onChange?: (value: string | null) => void;
    /** Tabs orientation @default `'horizontal'` */
    orientation?: 'vertical' | 'horizontal';
    /** `Tabs.List` placement relative to `Tabs.Panel`, applicable only when `orientation="vertical"` @default `'left'` */
    placement?: 'left' | 'right';
    /** Base id, used to generate ids to connect labels with controls, generated randomly by default */
    id?: string;
    /** If set, arrow key presses loop though items (first to last and last to first) @default `true` */
    loop?: boolean;
    /** If set, tab is activated with arrow key press @default `true` */
    activateTabWithKeyboard?: boolean;
    /** If set, tab can be deactivated @default `false` */
    allowTabDeactivation?: boolean;
    /** Tabs content */
    children?: React.ReactNode;
    /** Changes colors of `Tabs.Tab` components when variant is `pills` or `default`, does nothing for other variants */
    color?: MantineColor;
    /** Key of `theme.radius` or any valid CSS value to set `border-radius`@default `theme.defaultRadius` */
    radius?: MantineRadius;
    /** Determines whether tabs should have inverted styles @default `false` */
    inverted?: boolean;
    /** If set to `false`, `Tabs.Panel` content will be unmounted when the associated tab is not active @default `true` */
    keepMounted?: boolean;
    /** If set, adjusts text color based on background color for `pills` variant */
    autoContrast?: boolean;
}
export type TabsFactory = Factory<{
    props: TabsProps;
    ref: HTMLDivElement;
    variant: TabsVariant;
    stylesNames: TabsStylesNames;
    vars: TabsCssVariables;
    staticComponents: {
        Tab: typeof TabsTab;
        Panel: typeof TabsPanel;
        List: typeof TabsList;
    };
}>;
export declare const Tabs: import("../..").MantineComponent<{
    props: TabsProps;
    ref: HTMLDivElement;
    variant: TabsVariant;
    stylesNames: TabsStylesNames;
    vars: TabsCssVariables;
    staticComponents: {
        Tab: typeof TabsTab;
        Panel: typeof TabsPanel;
        List: typeof TabsList;
    };
}>;
