import { BoxProps, StylesApiProps } from '../../core';
import { __BaseInputProps } from './Input';
interface BaseProps extends __BaseInputProps, BoxProps, StylesApiProps<{
    props: any;
    stylesNames: string;
}> {
    __staticSelector?: string;
    __stylesApiProps?: Record<string, any>;
    id?: string;
}
export declare function useInputProps<T extends BaseProps, U extends Partial<T> | null>(component: string, defaultProps: U, _props: T): Omit<T & (U extends null | undefined ? {} : { [Key in Extract<keyof T, keyof U>]-?: U[Key] | NonNullable<T[Key]>; }), "label" | "style" | "size" | "styles" | "className" | "id" | "vars" | "variant" | "unstyled" | "attributes" | "classNames" | "mod" | "error" | "description" | "__staticSelector" | "required" | "__stylesApiProps" | "withAsterisk" | "labelProps" | "descriptionProps" | "errorProps" | "inputContainer" | "inputWrapperOrder" | "wrapperProps"> & {
    classNames: Partial<Record<string, string>> | ((theme: import("../..").MantineTheme, props: any, ctx: unknown) => Partial<Record<string, string>>) | undefined;
    styles: Partial<Record<string, import("../..").CSSProperties>> | ((theme: import("../..").MantineTheme, props: any, ctx: unknown) => Partial<Record<string, import("../..").CSSProperties>>) | undefined;
    unstyled: boolean | undefined;
    wrapperProps: {
        children?: import("react").ReactNode | undefined;
        onKeyDown?: import("react").KeyboardEventHandler<HTMLDivElement> | undefined;
        dir?: string | undefined;
        slot?: string | undefined;
        style: import("react").CSSProperties | ((theme: import("../..").MantineTheme) => import("../..").CSSProperties) | import("../..").MantineStyleProp[] | undefined;
        title?: string | undefined;
        popover?: "" | "auto" | "manual" | undefined;
        hidden?: boolean | undefined;
        color?: string | undefined;
        content?: string | undefined;
        translate?: "yes" | "no" | undefined;
        key?: import("react").Key | null | undefined;
        defaultChecked?: boolean | undefined;
        defaultValue?: string | number | readonly string[] | undefined;
        suppressContentEditableWarning?: boolean | undefined;
        suppressHydrationWarning?: boolean | undefined;
        accessKey?: string | undefined;
        autoCapitalize?: "off" | "none" | "on" | "sentences" | "words" | "characters" | undefined | (string & {});
        autoFocus?: boolean | undefined;
        className: string | undefined;
        contentEditable?: (boolean | "false" | "true") | "inherit" | "plaintext-only" | undefined;
        contextMenu?: string | undefined;
        draggable?: (boolean | "false" | "true") | undefined;
        enterKeyHint?: "enter" | "done" | "go" | "next" | "previous" | "search" | "send" | undefined;
        id: string | undefined;
        lang?: string | undefined;
        nonce?: string | undefined;
        spellCheck?: (boolean | "false" | "true") | undefined;
        tabIndex?: number | undefined;
        radioGroup?: string | undefined;
        role?: import("react").AriaRole | undefined;
        about?: string | undefined;
        datatype?: string | undefined;
        inlist?: any;
        prefix?: string | undefined;
        property?: string | undefined;
        rel?: string | undefined;
        resource?: string | undefined;
        rev?: string | undefined;
        typeof?: string | undefined;
        vocab?: string | undefined;
        autoCorrect?: string | undefined;
        autoSave?: string | undefined;
        itemProp?: string | undefined;
        itemScope?: boolean | undefined;
        itemType?: string | undefined;
        itemID?: string | undefined;
        itemRef?: string | undefined;
        results?: number | undefined;
        security?: string | undefined;
        unselectable?: "on" | "off" | undefined;
        popoverTargetAction?: "toggle" | "show" | "hide" | undefined;
        popoverTarget?: string | undefined;
        inert?: boolean | undefined;
        inputMode?: "none" | "text" | "tel" | "url" | "email" | "numeric" | "decimal" | "search" | undefined;
        is?: string | undefined;
        exportparts?: string | undefined;
        part?: string | undefined;
        "aria-activedescendant"?: string | undefined;
        "aria-atomic"?: (boolean | "false" | "true") | undefined;
        "aria-autocomplete"?: "none" | "inline" | "list" | "both" | undefined;
        "aria-braillelabel"?: string | undefined;
        "aria-brailleroledescription"?: string | undefined;
        "aria-busy"?: (boolean | "false" | "true") | undefined;
        "aria-checked"?: boolean | "false" | "mixed" | "true" | undefined;
        "aria-colcount"?: number | undefined;
        "aria-colindex"?: number | undefined;
        "aria-colindextext"?: string | undefined;
        "aria-colspan"?: number | undefined;
        "aria-controls"?: string | undefined;
        "aria-current"?: boolean | "false" | "true" | "page" | "step" | "location" | "date" | "time" | undefined;
        "aria-describedby"?: string | undefined;
        "aria-description"?: string | undefined;
        "aria-details"?: string | undefined;
        "aria-disabled"?: (boolean | "false" | "true") | undefined;
        "aria-dropeffect"?: "none" | "copy" | "execute" | "link" | "move" | "popup" | undefined;
        "aria-errormessage"?: string | undefined;
        "aria-expanded"?: (boolean | "false" | "true") | undefined;
        "aria-flowto"?: string | undefined;
        "aria-grabbed"?: (boolean | "false" | "true") | undefined;
        "aria-haspopup"?: boolean | "false" | "true" | "menu" | "listbox" | "tree" | "grid" | "dialog" | undefined;
        "aria-hidden"?: (boolean | "false" | "true") | undefined;
        "aria-invalid"?: boolean | "false" | "true" | "grammar" | "spelling" | undefined;
        "aria-keyshortcuts"?: string | undefined;
        "aria-label"?: string | undefined;
        "aria-labelledby"?: string | undefined;
        "aria-level"?: number | undefined;
        "aria-live"?: "off" | "assertive" | "polite" | undefined;
        "aria-modal"?: (boolean | "false" | "true") | undefined;
        "aria-multiline"?: (boolean | "false" | "true") | undefined;
        "aria-multiselectable"?: (boolean | "false" | "true") | undefined;
        "aria-orientation"?: "horizontal" | "vertical" | undefined;
        "aria-owns"?: string | undefined;
        "aria-placeholder"?: string | undefined;
        "aria-posinset"?: number | undefined;
        "aria-pressed"?: boolean | "false" | "mixed" | "true" | undefined;
        "aria-readonly"?: (boolean | "false" | "true") | undefined;
        "aria-relevant"?: "additions" | "additions removals" | "additions text" | "all" | "removals" | "removals additions" | "removals text" | "text" | "text additions" | "text removals" | undefined;
        "aria-required"?: (boolean | "false" | "true") | undefined;
        "aria-roledescription"?: string | undefined;
        "aria-rowcount"?: number | undefined;
        "aria-rowindex"?: number | undefined;
        "aria-rowindextext"?: string | undefined;
        "aria-rowspan"?: number | undefined;
        "aria-selected"?: (boolean | "false" | "true") | undefined;
        "aria-setsize"?: number | undefined;
        "aria-sort"?: "none" | "ascending" | "descending" | "other" | undefined;
        "aria-valuemax"?: number | undefined;
        "aria-valuemin"?: number | undefined;
        "aria-valuenow"?: number | undefined;
        "aria-valuetext"?: string | undefined;
        dangerouslySetInnerHTML?: {
            __html: string | TrustedHTML;
        } | undefined;
        onCopy?: import("react").ClipboardEventHandler<HTMLDivElement> | undefined;
        onCopyCapture?: import("react").ClipboardEventHandler<HTMLDivElement> | undefined;
        onCut?: import("react").ClipboardEventHandler<HTMLDivElement> | undefined;
        onCutCapture?: import("react").ClipboardEventHandler<HTMLDivElement> | undefined;
        onPaste?: import("react").ClipboardEventHandler<HTMLDivElement> | undefined;
        onPasteCapture?: import("react").ClipboardEventHandler<HTMLDivElement> | undefined;
        onCompositionEnd?: import("react").CompositionEventHandler<HTMLDivElement> | undefined;
        onCompositionEndCapture?: import("react").CompositionEventHandler<HTMLDivElement> | undefined;
        onCompositionStart?: import("react").CompositionEventHandler<HTMLDivElement> | undefined;
        onCompositionStartCapture?: import("react").CompositionEventHandler<HTMLDivElement> | undefined;
        onCompositionUpdate?: import("react").CompositionEventHandler<HTMLDivElement> | undefined;
        onCompositionUpdateCapture?: import("react").CompositionEventHandler<HTMLDivElement> | undefined;
        onFocus?: import("react").FocusEventHandler<HTMLDivElement> | undefined;
        onFocusCapture?: import("react").FocusEventHandler<HTMLDivElement> | undefined;
        onBlur?: import("react").FocusEventHandler<HTMLDivElement> | undefined;
        onBlurCapture?: import("react").FocusEventHandler<HTMLDivElement> | undefined;
        onChange?: import("react").FormEventHandler<HTMLDivElement> | undefined;
        onChangeCapture?: import("react").FormEventHandler<HTMLDivElement> | undefined;
        onBeforeInput?: import("react").InputEventHandler<HTMLDivElement> | undefined;
        onBeforeInputCapture?: import("react").FormEventHandler<HTMLDivElement> | undefined;
        onInput?: import("react").FormEventHandler<HTMLDivElement> | undefined;
        onInputCapture?: import("react").FormEventHandler<HTMLDivElement> | undefined;
        onReset?: import("react").FormEventHandler<HTMLDivElement> | undefined;
        onResetCapture?: import("react").FormEventHandler<HTMLDivElement> | undefined;
        onSubmit?: import("react").FormEventHandler<HTMLDivElement> | undefined;
        onSubmitCapture?: import("react").FormEventHandler<HTMLDivElement> | undefined;
        onInvalid?: import("react").FormEventHandler<HTMLDivElement> | undefined;
        onInvalidCapture?: import("react").FormEventHandler<HTMLDivElement> | undefined;
        onLoad?: import("react").ReactEventHandler<HTMLDivElement> | undefined;
        onLoadCapture?: import("react").ReactEventHandler<HTMLDivElement> | undefined;
        onError?: import("react").ReactEventHandler<HTMLDivElement> | undefined;
        onErrorCapture?: import("react").ReactEventHandler<HTMLDivElement> | undefined;
        onKeyDownCapture?: import("react").KeyboardEventHandler<HTMLDivElement> | undefined;
        onKeyPress?: import("react").KeyboardEventHandler<HTMLDivElement> | undefined;
        onKeyPressCapture?: import("react").KeyboardEventHandler<HTMLDivElement> | undefined;
        onKeyUp?: import("react").KeyboardEventHandler<HTMLDivElement> | undefined;
        onKeyUpCapture?: import("react").KeyboardEventHandler<HTMLDivElement> | undefined;
        onAbort?: import("react").ReactEventHandler<HTMLDivElement> | undefined;
        onAbortCapture?: import("react").ReactEventHandler<HTMLDivElement> | undefined;
        onCanPlay?: import("react").ReactEventHandler<HTMLDivElement> | undefined;
        onCanPlayCapture?: import("react").ReactEventHandler<HTMLDivElement> | undefined;
        onCanPlayThrough?: import("react").ReactEventHandler<HTMLDivElement> | undefined;
        onCanPlayThroughCapture?: import("react").ReactEventHandler<HTMLDivElement> | undefined;
        onDurationChange?: import("react").ReactEventHandler<HTMLDivElement> | undefined;
        onDurationChangeCapture?: import("react").ReactEventHandler<HTMLDivElement> | undefined;
        onEmptied?: import("react").ReactEventHandler<HTMLDivElement> | undefined;
        onEmptiedCapture?: import("react").ReactEventHandler<HTMLDivElement> | undefined;
        onEncrypted?: import("react").ReactEventHandler<HTMLDivElement> | undefined;
        onEncryptedCapture?: import("react").ReactEventHandler<HTMLDivElement> | undefined;
        onEnded?: import("react").ReactEventHandler<HTMLDivElement> | undefined;
        onEndedCapture?: import("react").ReactEventHandler<HTMLDivElement> | undefined;
        onLoadedData?: import("react").ReactEventHandler<HTMLDivElement> | undefined;
        onLoadedDataCapture?: import("react").ReactEventHandler<HTMLDivElement> | undefined;
        onLoadedMetadata?: import("react").ReactEventHandler<HTMLDivElement> | undefined;
        onLoadedMetadataCapture?: import("react").ReactEventHandler<HTMLDivElement> | undefined;
        onLoadStart?: import("react").ReactEventHandler<HTMLDivElement> | undefined;
        onLoadStartCapture?: import("react").ReactEventHandler<HTMLDivElement> | undefined;
        onPause?: import("react").ReactEventHandler<HTMLDivElement> | undefined;
        onPauseCapture?: import("react").ReactEventHandler<HTMLDivElement> | undefined;
        onPlay?: import("react").ReactEventHandler<HTMLDivElement> | undefined;
        onPlayCapture?: import("react").ReactEventHandler<HTMLDivElement> | undefined;
        onPlaying?: import("react").ReactEventHandler<HTMLDivElement> | undefined;
        onPlayingCapture?: import("react").ReactEventHandler<HTMLDivElement> | undefined;
        onProgress?: import("react").ReactEventHandler<HTMLDivElement> | undefined;
        onProgressCapture?: import("react").ReactEventHandler<HTMLDivElement> | undefined;
        onRateChange?: import("react").ReactEventHandler<HTMLDivElement> | undefined;
        onRateChangeCapture?: import("react").ReactEventHandler<HTMLDivElement> | undefined;
        onSeeked?: import("react").ReactEventHandler<HTMLDivElement> | undefined;
        onSeekedCapture?: import("react").ReactEventHandler<HTMLDivElement> | undefined;
        onSeeking?: import("react").ReactEventHandler<HTMLDivElement> | undefined;
        onSeekingCapture?: import("react").ReactEventHandler<HTMLDivElement> | undefined;
        onStalled?: import("react").ReactEventHandler<HTMLDivElement> | undefined;
        onStalledCapture?: import("react").ReactEventHandler<HTMLDivElement> | undefined;
        onSuspend?: import("react").ReactEventHandler<HTMLDivElement> | undefined;
        onSuspendCapture?: import("react").ReactEventHandler<HTMLDivElement> | undefined;
        onTimeUpdate?: import("react").ReactEventHandler<HTMLDivElement> | undefined;
        onTimeUpdateCapture?: import("react").ReactEventHandler<HTMLDivElement> | undefined;
        onVolumeChange?: import("react").ReactEventHandler<HTMLDivElement> | undefined;
        onVolumeChangeCapture?: import("react").ReactEventHandler<HTMLDivElement> | undefined;
        onWaiting?: import("react").ReactEventHandler<HTMLDivElement> | undefined;
        onWaitingCapture?: import("react").ReactEventHandler<HTMLDivElement> | undefined;
        onAuxClick?: import("react").MouseEventHandler<HTMLDivElement> | undefined;
        onAuxClickCapture?: import("react").MouseEventHandler<HTMLDivElement> | undefined;
        onClick?: import("react").MouseEventHandler<HTMLDivElement> | undefined;
        onClickCapture?: import("react").MouseEventHandler<HTMLDivElement> | undefined;
        onContextMenu?: import("react").MouseEventHandler<HTMLDivElement> | undefined;
        onContextMenuCapture?: import("react").MouseEventHandler<HTMLDivElement> | undefined;
        onDoubleClick?: import("react").MouseEventHandler<HTMLDivElement> | undefined;
        onDoubleClickCapture?: import("react").MouseEventHandler<HTMLDivElement> | undefined;
        onDrag?: import("react").DragEventHandler<HTMLDivElement> | undefined;
        onDragCapture?: import("react").DragEventHandler<HTMLDivElement> | undefined;
        onDragEnd?: import("react").DragEventHandler<HTMLDivElement> | undefined;
        onDragEndCapture?: import("react").DragEventHandler<HTMLDivElement> | undefined;
        onDragEnter?: import("react").DragEventHandler<HTMLDivElement> | undefined;
        onDragEnterCapture?: import("react").DragEventHandler<HTMLDivElement> | undefined;
        onDragExit?: import("react").DragEventHandler<HTMLDivElement> | undefined;
        onDragExitCapture?: import("react").DragEventHandler<HTMLDivElement> | undefined;
        onDragLeave?: import("react").DragEventHandler<HTMLDivElement> | undefined;
        onDragLeaveCapture?: import("react").DragEventHandler<HTMLDivElement> | undefined;
        onDragOver?: import("react").DragEventHandler<HTMLDivElement> | undefined;
        onDragOverCapture?: import("react").DragEventHandler<HTMLDivElement> | undefined;
        onDragStart?: import("react").DragEventHandler<HTMLDivElement> | undefined;
        onDragStartCapture?: import("react").DragEventHandler<HTMLDivElement> | undefined;
        onDrop?: import("react").DragEventHandler<HTMLDivElement> | undefined;
        onDropCapture?: import("react").DragEventHandler<HTMLDivElement> | undefined;
        onMouseDown?: import("react").MouseEventHandler<HTMLDivElement> | undefined;
        onMouseDownCapture?: import("react").MouseEventHandler<HTMLDivElement> | undefined;
        onMouseEnter?: import("react").MouseEventHandler<HTMLDivElement> | undefined;
        onMouseLeave?: import("react").MouseEventHandler<HTMLDivElement> | undefined;
        onMouseMove?: import("react").MouseEventHandler<HTMLDivElement> | undefined;
        onMouseMoveCapture?: import("react").MouseEventHandler<HTMLDivElement> | undefined;
        onMouseOut?: import("react").MouseEventHandler<HTMLDivElement> | undefined;
        onMouseOutCapture?: import("react").MouseEventHandler<HTMLDivElement> | undefined;
        onMouseOver?: import("react").MouseEventHandler<HTMLDivElement> | undefined;
        onMouseOverCapture?: import("react").MouseEventHandler<HTMLDivElement> | undefined;
        onMouseUp?: import("react").MouseEventHandler<HTMLDivElement> | undefined;
        onMouseUpCapture?: import("react").MouseEventHandler<HTMLDivElement> | undefined;
        onSelect?: import("react").ReactEventHandler<HTMLDivElement> | undefined;
        onSelectCapture?: import("react").ReactEventHandler<HTMLDivElement> | undefined;
        onTouchCancel?: import("react").TouchEventHandler<HTMLDivElement> | undefined;
        onTouchCancelCapture?: import("react").TouchEventHandler<HTMLDivElement> | undefined;
        onTouchEnd?: import("react").TouchEventHandler<HTMLDivElement> | undefined;
        onTouchEndCapture?: import("react").TouchEventHandler<HTMLDivElement> | undefined;
        onTouchMove?: import("react").TouchEventHandler<HTMLDivElement> | undefined;
        onTouchMoveCapture?: import("react").TouchEventHandler<HTMLDivElement> | undefined;
        onTouchStart?: import("react").TouchEventHandler<HTMLDivElement> | undefined;
        onTouchStartCapture?: import("react").TouchEventHandler<HTMLDivElement> | undefined;
        onPointerDown?: import("react").PointerEventHandler<HTMLDivElement> | undefined;
        onPointerDownCapture?: import("react").PointerEventHandler<HTMLDivElement> | undefined;
        onPointerMove?: import("react").PointerEventHandler<HTMLDivElement> | undefined;
        onPointerMoveCapture?: import("react").PointerEventHandler<HTMLDivElement> | undefined;
        onPointerUp?: import("react").PointerEventHandler<HTMLDivElement> | undefined;
        onPointerUpCapture?: import("react").PointerEventHandler<HTMLDivElement> | undefined;
        onPointerCancel?: import("react").PointerEventHandler<HTMLDivElement> | undefined;
        onPointerCancelCapture?: import("react").PointerEventHandler<HTMLDivElement> | undefined;
        onPointerEnter?: import("react").PointerEventHandler<HTMLDivElement> | undefined;
        onPointerLeave?: import("react").PointerEventHandler<HTMLDivElement> | undefined;
        onPointerOver?: import("react").PointerEventHandler<HTMLDivElement> | undefined;
        onPointerOverCapture?: import("react").PointerEventHandler<HTMLDivElement> | undefined;
        onPointerOut?: import("react").PointerEventHandler<HTMLDivElement> | undefined;
        onPointerOutCapture?: import("react").PointerEventHandler<HTMLDivElement> | undefined;
        onGotPointerCapture?: import("react").PointerEventHandler<HTMLDivElement> | undefined;
        onGotPointerCaptureCapture?: import("react").PointerEventHandler<HTMLDivElement> | undefined;
        onLostPointerCapture?: import("react").PointerEventHandler<HTMLDivElement> | undefined;
        onLostPointerCaptureCapture?: import("react").PointerEventHandler<HTMLDivElement> | undefined;
        onScroll?: import("react").UIEventHandler<HTMLDivElement> | undefined;
        onScrollCapture?: import("react").UIEventHandler<HTMLDivElement> | undefined;
        onScrollEnd?: import("react").UIEventHandler<HTMLDivElement> | undefined;
        onScrollEndCapture?: import("react").UIEventHandler<HTMLDivElement> | undefined;
        onWheel?: import("react").WheelEventHandler<HTMLDivElement> | undefined;
        onWheelCapture?: import("react").WheelEventHandler<HTMLDivElement> | undefined;
        onAnimationStart?: import("react").AnimationEventHandler<HTMLDivElement> | undefined;
        onAnimationStartCapture?: import("react").AnimationEventHandler<HTMLDivElement> | undefined;
        onAnimationEnd?: import("react").AnimationEventHandler<HTMLDivElement> | undefined;
        onAnimationEndCapture?: import("react").AnimationEventHandler<HTMLDivElement> | undefined;
        onAnimationIteration?: import("react").AnimationEventHandler<HTMLDivElement> | undefined;
        onAnimationIterationCapture?: import("react").AnimationEventHandler<HTMLDivElement> | undefined;
        onToggle?: import("react").ToggleEventHandler<HTMLDivElement> | undefined;
        onBeforeToggle?: import("react").ToggleEventHandler<HTMLDivElement> | undefined;
        onTransitionCancel?: import("react").TransitionEventHandler<HTMLDivElement> | undefined;
        onTransitionCancelCapture?: import("react").TransitionEventHandler<HTMLDivElement> | undefined;
        onTransitionEnd?: import("react").TransitionEventHandler<HTMLDivElement> | undefined;
        onTransitionEndCapture?: import("react").TransitionEventHandler<HTMLDivElement> | undefined;
        onTransitionRun?: import("react").TransitionEventHandler<HTMLDivElement> | undefined;
        onTransitionRunCapture?: import("react").TransitionEventHandler<HTMLDivElement> | undefined;
        onTransitionStart?: import("react").TransitionEventHandler<HTMLDivElement> | undefined;
        onTransitionStartCapture?: import("react").TransitionEventHandler<HTMLDivElement> | undefined;
        label: import("react").ReactNode;
        description: import("react").ReactNode;
        error: import("react").ReactNode;
        required: boolean | undefined;
        classNames: Partial<Record<string, string>> | ((theme: import("../..").MantineTheme, props: any, ctx: unknown) => Partial<Record<string, string>>) | undefined;
        __staticSelector: string | undefined;
        __stylesApiProps: Record<string, any> | BaseProps;
        errorProps: (import(".").InputErrorProps & import("../..").DataAttributes) | undefined;
        labelProps: (import(".").InputLabelProps & import("../..").DataAttributes) | undefined;
        descriptionProps: (import(".").InputDescriptionProps & import("../..").DataAttributes) | undefined;
        unstyled: boolean | undefined;
        styles: Partial<Record<string, import("../..").CSSProperties>> | ((theme: import("../..").MantineTheme, props: any, ctx: unknown) => Partial<Record<string, import("../..").CSSProperties>>) | undefined;
        size: (string & {}) | import("../..").MantineSize | undefined;
        inputContainer: ((children: React.ReactNode) => React.ReactNode) | undefined;
        inputWrapperOrder: ("input" | "label" | "error" | "description")[] | undefined;
        withAsterisk: boolean | undefined;
        variant: string | undefined;
        mod: import("../..").BoxMod | undefined;
        attributes: {
            [x: string]: Record<string, any> | undefined;
        } | undefined;
    } & BoxProps;
    inputProps: {
        required: boolean | undefined;
        classNames: Partial<Record<string, string>> | ((theme: import("../..").MantineTheme, props: any, ctx: unknown) => Partial<Record<string, string>>) | undefined;
        styles: Partial<Record<string, import("../..").CSSProperties>> | ((theme: import("../..").MantineTheme, props: any, ctx: unknown) => Partial<Record<string, import("../..").CSSProperties>>) | undefined;
        unstyled: boolean | undefined;
        size: (string & {}) | import("../..").MantineSize | undefined;
        __staticSelector: string | undefined;
        __stylesApiProps: Record<string, any> | BaseProps;
        error: import("react").ReactNode;
        variant: string | undefined;
        id: string | undefined;
        attributes: {
            [x: string]: Record<string, any> | undefined;
        } | undefined;
    };
};
export {};
