import { BoxProps, MantineColor, MantineGradient, MantineRadius, MantineSize, PolymorphicFactory, StylesApiProps } from '../../core';
import { AvatarGroup } from './AvatarGroup/AvatarGroup';
export type AvatarStylesNames = 'root' | 'placeholder' | 'image';
export type AvatarVariant = 'filled' | 'light' | 'gradient' | 'outline' | 'transparent' | 'default' | 'white';
export type AvatarCssVariables = {
    root: '--avatar-size' | '--avatar-radius' | '--avatar-bg' | '--avatar-color' | '--avatar-bd';
};
export interface AvatarProps extends BoxProps, StylesApiProps<AvatarFactory> {
    /** Width and height of the avatar, numbers are converted to rem @default `'md'` */
    size?: MantineSize | (string & {}) | number;
    /** Key of `theme.radius` or any valid CSS value to set border-radius @default `'1000px'` */
    radius?: MantineRadius;
    /** Key of `theme.colors` or any valid CSS color @default `'gray'` */
    color?: MantineColor | 'initials';
    /** Gradient configuration for `variant="gradient"` @default `theme.defaultGradient` */
    gradient?: MantineGradient;
    /** Image url, if the image cannot be loaded or `src={null}`, then placeholder is displayed instead */
    src?: string | null;
    /** Image `alt` attribute, also used as `title` attribute for placeholder */
    alt?: string;
    /** Attributes passed down to `img` element */
    imageProps?: React.ComponentPropsWithoutRef<'img'>;
    /** Avatar placeholder, displayed when `src={null}` or when the image cannot be loaded */
    children?: React.ReactNode;
    /** If set, adjusts text color based on background color for `filled` variant */
    autoContrast?: boolean;
    /** Name of the user. When `src` is not set, used to display initials and to generate color when `color="initials"` is set. */
    name?: string;
    /** A list of colors that is used for autogenerated initials. By default, all default Mantine colors can be used except gray and dark. */
    allowedInitialsColors?: MantineColor[];
}
export type AvatarFactory = PolymorphicFactory<{
    props: AvatarProps;
    defaultRef: HTMLDivElement;
    defaultComponent: 'div';
    stylesNames: AvatarStylesNames;
    vars: AvatarCssVariables;
    variant: AvatarVariant;
    staticComponents: {
        Group: typeof AvatarGroup;
    };
}>;
export declare const Avatar: (<C = "div">(props: import("../..").PolymorphicComponentProps<C, AvatarProps>) => React.ReactElement) & Omit<import("react").FunctionComponent<(AvatarProps & {
    component?: any;
} & Omit<Omit<any, "ref">, "component" | keyof AvatarProps> & {
    ref?: any;
    renderRoot?: (props: any) => any;
}) | (AvatarProps & {
    component: React.ElementType;
    renderRoot?: (props: Record<string, any>) => any;
})>, never> & import("../../core/factory/factory").ThemeExtend<{
    props: AvatarProps;
    defaultRef: HTMLDivElement;
    defaultComponent: "div";
    stylesNames: AvatarStylesNames;
    vars: AvatarCssVariables;
    variant: AvatarVariant;
    staticComponents: {
        Group: typeof AvatarGroup;
    };
}> & import("../../core/factory/factory").ComponentClasses<{
    props: AvatarProps;
    defaultRef: HTMLDivElement;
    defaultComponent: "div";
    stylesNames: AvatarStylesNames;
    vars: AvatarCssVariables;
    variant: AvatarVariant;
    staticComponents: {
        Group: typeof AvatarGroup;
    };
}> & import("../../core/factory/polymorphic-factory").PolymorphicComponentWithProps<{
    props: AvatarProps;
    defaultRef: HTMLDivElement;
    defaultComponent: "div";
    stylesNames: AvatarStylesNames;
    vars: AvatarCssVariables;
    variant: AvatarVariant;
    staticComponents: {
        Group: typeof AvatarGroup;
    };
}> & {
    Group: typeof AvatarGroup;
};
