'use client';
import { jsxs, Fragment, jsx } from 'react/jsx-runtime';
import { useUncontrolled } from '@mantine/hooks';
import '../../core/utils/units-converters/rem.mjs';
import 'react';
import { getSpacing } from '../../core/utils/get-size/get-size.mjs';
import { createVarsResolver } from '../../core/styles-api/create-vars-resolver/create-vars-resolver.mjs';
import 'clsx';
import '../../core/MantineProvider/Mantine.context.mjs';
import '../../core/MantineProvider/default-theme.mjs';
import '../../core/MantineProvider/MantineProvider.mjs';
import '../../core/MantineProvider/MantineThemeProvider/MantineThemeProvider.mjs';
import { useProps } from '../../core/MantineProvider/use-props/use-props.mjs';
import '../../core/MantineProvider/MantineCssVariables/MantineCssVariables.mjs';
import { useStyles } from '../../core/styles-api/use-styles/use-styles.mjs';
import { Box } from '../../core/Box/Box.mjs';
import { polymorphicFactory } from '../../core/factory/polymorphic-factory.mjs';
import '../../core/DirectionProvider/DirectionProvider.mjs';
import '../Accordion/Accordion.mjs';
import { AccordionChevron } from '../Accordion/AccordionChevron.mjs';
import '../Accordion/AccordionItem/AccordionItem.mjs';
import '../Accordion/AccordionPanel/AccordionPanel.mjs';
import '../Accordion/AccordionControl/AccordionControl.mjs';
import { Collapse } from '../Collapse/Collapse.mjs';
import { UnstyledButton } from '../UnstyledButton/UnstyledButton.mjs';
import classes from './NavLink.module.css.mjs';

const varsResolver = createVarsResolver(
  (theme, { variant, color, childrenOffset, autoContrast }) => {
    const colors = theme.variantColorResolver({
      color: color || theme.primaryColor,
      theme,
      variant: variant || "light",
      autoContrast
    });
    return {
      root: {
        "--nl-bg": color || variant ? colors.background : void 0,
        "--nl-hover": color || variant ? colors.hover : void 0,
        "--nl-color": color || variant ? colors.color : void 0
      },
      children: {
        "--nl-offset": getSpacing(childrenOffset)
      }
    };
  }
);
const NavLink = polymorphicFactory((_props, ref) => {
  const props = useProps("NavLink", null, _props);
  const {
    classNames,
    className,
    style,
    styles,
    unstyled,
    vars,
    opened,
    defaultOpened,
    onChange,
    children,
    active,
    disabled,
    leftSection,
    rightSection,
    label,
    description,
    disableRightSectionRotation,
    noWrap,
    childrenOffset,
    autoContrast,
    mod,
    attributes,
    onClick,
    onKeyDown,
    ...others
  } = props;
  const getStyles = useStyles({
    name: "NavLink",
    props,
    classes,
    className,
    style,
    classNames,
    styles,
    unstyled,
    attributes,
    vars,
    varsResolver
  });
  const [_opened, setOpened] = useUncontrolled({
    value: opened,
    defaultValue: defaultOpened,
    finalValue: false,
    onChange
  });
  const withChildren = !!children;
  const handleClick = (event) => {
    onClick?.(event);
    if (withChildren) {
      event.preventDefault();
      setOpened(!_opened);
    }
  };
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsxs(
      UnstyledButton,
      {
        ...getStyles("root"),
        component: "a",
        ref,
        onClick: handleClick,
        onKeyDown: (event) => {
          onKeyDown?.(event);
          if (event.nativeEvent.code === "Space" && withChildren) {
            event.preventDefault();
            setOpened(!_opened);
          }
        },
        unstyled,
        mod: [{ disabled, active, expanded: _opened }, mod],
        ...others,
        children: [
          leftSection && /* @__PURE__ */ jsx(Box, { component: "span", ...getStyles("section"), mod: { position: "left" }, children: leftSection }),
          /* @__PURE__ */ jsxs(Box, { ...getStyles("body"), mod: { "no-wrap": noWrap }, children: [
            /* @__PURE__ */ jsx(Box, { component: "span", ...getStyles("label"), children: label }),
            /* @__PURE__ */ jsx(Box, { component: "span", mod: { active }, ...getStyles("description"), children: description })
          ] }),
          (withChildren || rightSection !== void 0) && /* @__PURE__ */ jsx(
            Box,
            {
              ...getStyles("section"),
              component: "span",
              mod: { rotate: _opened && !disableRightSectionRotation, position: "right" },
              children: withChildren ? rightSection !== void 0 ? rightSection : /* @__PURE__ */ jsx(AccordionChevron, { ...getStyles("chevron") }) : rightSection
            }
          )
        ]
      }
    ),
    withChildren && /* @__PURE__ */ jsx(Collapse, { in: _opened, ...getStyles("collapse"), children: /* @__PURE__ */ jsx("div", { ...getStyles("children"), children }) })
  ] });
});
NavLink.classes = classes;
NavLink.displayName = "@mantine/core/NavLink";

export { NavLink };
//# sourceMappingURL=NavLink.mjs.map
